/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.JGroupsCacheManager;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jgroups.JChannel;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RpcDispatcher;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class JGroupCacheManagerFactoryBean
extends AbstractFactoryBean<CacheManager>
implements BootstrapAware {
    private final RpcDispatcher dispatcher = new RpcDispatcher();
    private final JChannel jchannel;
    private Bootstrap bootstrap;

    public JGroupCacheManagerFactoryBean(JChannel jchannel) {
        this.jchannel = Objects.requireNonNull(jchannel);
    }

    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public Class<?> getObjectType() {
        return CacheManager.class;
    }

    protected CacheManager createInstance() throws Exception {
        while (true) {
            try {
                JGroupsCacheManager manager = new JGroupsCacheManager(this.dispatcher);
                manager.setBootstrap(this.bootstrap);
                this.dispatcher.setAsynDispatching(true);
                this.dispatcher.setChannel(this.jchannel);
                this.dispatcher.setServerObject((Object)manager);
                this.dispatcher.setMethodLookup((MethodLookup)manager);
                this.dispatcher.start();
                return manager;
            }
            catch (Throwable err) {
                ExceptionUtils.wrapAndThrow((Throwable)err);
                continue;
            }
            break;
        }
    }

    protected void destroyInstance(CacheManager instance) throws Exception {
        this.dispatcher.close();
    }
}

