/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.turbospaces.ebean.LocalCache;
import io.ebean.cache.ServerCacheStatistics;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCache
implements LocalCache,
Supplier<Cache<Object, Object>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String cacheKey;
    private final Cache<Object, Object> cache;

    public SimpleCache(String cacheKey) {
        this.cacheKey = Objects.requireNonNull(cacheKey);
        this.cache = CacheBuilder.newBuilder().recordStats().build();
    }

    public Object get(Object id) {
        return this.cache.getIfPresent(id);
    }

    public void put(Object id, Object value) {
        this.cache.put(id, value);
    }

    public void remove(Object id) {
        this.cache.invalidate(id);
    }

    public int size() {
        return (int)this.cache.size();
    }

    public int hitRatio() {
        return (int)(this.cache.stats().hitRate() * 100.0);
    }

    public ServerCacheStatistics statistics(boolean reset) {
        CacheStats stats = this.cache.stats();
        ServerCacheStatistics scs = new ServerCacheStatistics();
        scs.setCacheName(this.cacheKey);
        scs.setEvictCount(stats.evictionCount());
        scs.setHitCount(stats.hitCount());
        scs.setMissCount(stats.missCount());
        scs.setSize(this.size());
        return scs;
    }

    public void clear() {
        this.logger.debug("clearing {}(items={})", (Object)this.cacheKey, (Object)this.cache.size());
        this.cache.invalidateAll();
        this.cleanUp();
    }

    @Override
    public int onClear() {
        long size = this.cache.size();
        this.clear();
        return (int)size;
    }

    @Override
    public void cleanUp() {
        this.cache.cleanUp();
    }

    @Override
    public Cache<Object, Object> get() {
        return this.cache;
    }

    public String toString() {
        return this.cacheKey;
    }
}

