/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.netflix.archaius.api.Config;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.JgroupsServerQueryCache;
import com.turbospaces.ebean.LocalEbeanCache;
import com.turbospaces.ebean.ReplicatedCache;
import com.turbospaces.ebean.ReplicatedEbeanCache;
import com.turbospaces.ebean.SimpleCache;
import io.ebean.BackgroundExecutor;
import io.ebean.DatabaseBuilder;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.cache.ServerCacheType;
import io.ebean.config.CurrentTenantProvider;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.cache.GuavaCacheMetrics;
import io.vavr.CheckedFunction0;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.time.StopWatch;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;

public class JGroupsCacheManager
extends AbstractBootstrapAware
implements MethodLookup,
CacheManager,
ServerCacheNotify {
    public static short METHOD_ON_CACHE_PUT = 1;
    public static short METHOD_ON_CHANGE_REMOVE = (short)2;
    public static short METHOD_ON_CACHE_CLEAR = (short)3;
    public static short METHOD_ON_MODIFIED = (short)4;
    public static short METHOD_ON_CACHE_CLEAR_ALL = (short)5;
    public static ImmutableMap<Short, Method> METHODS;
    private final RpcDispatcher dispatcher;
    private final ConcurrentMap<String, ServerCache> caches;
    private BackgroundExecutor executor;
    private ServerCacheNotify notify;

    public JGroupsCacheManager(RpcDispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.caches = Maps.newConcurrentMap();
    }

    public void setBootstrap(final Bootstrap bootstrap) throws Throwable {
        super.setBootstrap(bootstrap);
        long intervalMillis = ((Duration)bootstrap.props().CACHE_METRICS_REPORT_INTERVAL.get()).toMillis();
        bootstrap.globalPlatform().scheduleWithFixedDelay(() -> this.caches.forEach((key, value) -> {
            if (key.endsWith(ServerCacheType.QUERY.code())) {
                ServerCacheStatistics stats = value.statistics(true);
                bootstrap.meterRegistry().counter("query_cache.hits", new String[]{"name", key}).increment((double)stats.getHitCount());
                bootstrap.meterRegistry().counter("query_cache.puts", new String[]{"name", key}).increment((double)stats.getPutCount());
                bootstrap.meterRegistry().counter("query_cache.evicts", new String[]{"name", key}).increment((double)stats.getEvictCount());
                bootstrap.meterRegistry().gauge("query_cache.size", (Iterable)Tags.of((String)"name", (String)key), (Number)stats.getSize());
                bootstrap.meterRegistry().gauge("query_cache.maxSize", (Iterable)Tags.of((String)"name", (String)key), (Number)stats.getMaxSize());
                bootstrap.meterRegistry().gauge("query_cache.hit_ratio", (Iterable)Tags.of((String)"name", (String)key), (Number)stats.getHitRatio());
                bootstrap.meterRegistry().counter("query_cache.miss_count", new String[]{"name", key}).increment((double)stats.getMissCount());
                bootstrap.meterRegistry().counter("query_cache.ttl_count", new String[]{"name", key}).increment((double)stats.getTtlCount());
                bootstrap.meterRegistry().counter("query_cache.remove_count", new String[]{"name", key}).increment((double)stats.getRemoveCount());
                bootstrap.meterRegistry().counter("query_cache.clear_count", new String[]{"name", key}).increment((double)stats.getClearCount());
                bootstrap.meterRegistry().counter("query_cache.idle_count", new String[]{"name", key}).increment((double)stats.getIdleCount());
            }
        }), intervalMillis, intervalMillis, TimeUnit.MILLISECONDS);
        if (Objects.isNull(this.executor)) {
            this.setBackgroundExecutor(new BackgroundExecutor(){

                public Future<?> submit(Runnable task) {
                    return bootstrap.globalPlatform().submit(task);
                }

                public <T> Future<T> submit(Callable<T> task) {
                    return bootstrap.globalPlatform().submit(task);
                }

                public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
                    return bootstrap.globalPlatform().scheduleWithFixedDelay(task, initialDelay, delay, unit);
                }

                public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
                    return bootstrap.globalPlatform().scheduleAtFixedRate(task, initialDelay, period, unit);
                }

                public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
                    return bootstrap.globalPlatform().schedule(task, delay, unit);
                }

                public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
                    return bootstrap.globalPlatform().schedule(task, delay, unit);
                }

                public void execute(Runnable task) {
                    bootstrap.globalPlatform().execute(task);
                }
            });
        }
    }

    public Method findMethod(short id) {
        return (Method)METHODS.get((Object)id);
    }

    @Override
    public void setBackgroundExecutor(BackgroundExecutor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    public ServerCacheFactory create(DatabaseBuilder databaseBuilder, BackgroundExecutor backgroundExecutor) {
        this.setBackgroundExecutor(backgroundExecutor);
        return this;
    }

    public ServerCacheNotify createCacheNotify(ServerCacheNotify cacheNotify) {
        this.notify = Objects.requireNonNull(cacheNotify);
        return this;
    }

    public void notify(ServerCacheNotification notification) {
        if (notification.getDependentTables() != null && !notification.getDependentTables().isEmpty()) {
            final Set dependentTables = notification.getDependentTables();
            final String line = Joiner.on((char)',').join((Iterable)dependentTables);
            this.logger.debug("Publish TableMods - {}", (Object)line);
            final StopWatch stopWatch = StopWatch.createStarted();
            FluentFuture.from((ListenableFuture)this.bootstrap.globalPlatform().submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

                public CompletableFuture<RspList<Object>> apply() throws Throwable {
                    CompletableFuture future = CompletableFuture.completedFuture(null);
                    if (JGroupsCacheManager.this.dispatcher.getChannel().isOpen()) {
                        MethodCall call = new MethodCall(METHOD_ON_MODIFIED, new Object[]{line});
                        future = JGroupsCacheManager.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                        stopWatch.stop();
                    }
                    return future;
                }
            })).addCallback((FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    long time = stopWatch.getTime(TimeUnit.SECONDS);
                    if (time > 0L) {
                        JGroupsCacheManager.this.logger.error("notify operation took too long: {} for tables: {}", (Object)stopWatch, (Object)dependentTables);
                    }
                }

                public void onFailure(Throwable t) {
                    if (JGroupsCacheManager.this.dispatcher.getChannel().isOpen()) {
                        JGroupsCacheManager.this.logger.error(t.getMessage(), t);
                    } else {
                        JGroupsCacheManager.this.logger.warn(t.getMessage(), t);
                    }
                }
            }, MoreExecutors.directExecutor());
        }
    }

    @Override
    public void onTablesModify(String line) {
        Iterable it = Splitter.on((char)',').omitEmptyStrings().split((CharSequence)line);
        ImmutableSet tables = ImmutableSet.copyOf((Iterable)it);
        ServerCacheNotification notification = new ServerCacheNotification((Set)tables);
        if (Objects.nonNull(this.notify)) {
            this.notify.notify(notification);
        }
    }

    @Override
    public void onCachePut(String cacheKey, byte[] id, byte[] value) {
        ReplicatedEbeanCache cache = (ReplicatedEbeanCache)this.caches.get(cacheKey);
        if (Objects.nonNull(cache)) {
            cache.onPut(id, value);
        }
    }

    @Override
    public void onCacheRemove(String cacheKey, byte[] id) {
        ReplicatedEbeanCache cache = (ReplicatedEbeanCache)this.caches.get(cacheKey);
        if (Objects.nonNull(cache)) {
            cache.onRemove(id);
        }
    }

    @Override
    public void onCacheClear(String cacheKey) {
        ServerCache cache = (ServerCache)this.caches.get(cacheKey);
        if (Objects.nonNull(cache)) {
            if (cache instanceof ReplicatedEbeanCache) {
                ((ReplicatedEbeanCache)cache).onClear();
            } else if (cache instanceof JgroupsServerQueryCache) {
                ((JgroupsServerQueryCache)cache).onClear();
            }
        }
    }

    @Override
    public void onCacheClearAll(boolean preserveSimple) {
        for (ServerCache cache : this.caches.values()) {
            if (cache instanceof ReplicatedEbeanCache) {
                ((ReplicatedEbeanCache)cache).onClear();
                continue;
            }
            if (cache instanceof SimpleCache) {
                if (!BooleanUtils.isFalse((Boolean)preserveSimple)) continue;
                ((SimpleCache)cache).onClear();
                continue;
            }
            if (cache instanceof LocalEbeanCache) {
                ((LocalEbeanCache)cache).onClear();
                continue;
            }
            if (!(cache instanceof JgroupsServerQueryCache)) continue;
            ((JgroupsServerQueryCache)cache).onClear();
        }
    }

    @Override
    public ServerCache getCache(String cacheKey) {
        return (ServerCache)this.caches.get(cacheKey);
    }

    @Override
    public void clearAllLocal() {
        for (ServerCache cache : this.caches.values()) {
            if (!(cache instanceof LocalEbeanCache)) continue;
            ((LocalEbeanCache)cache).onClear();
        }
    }

    @Override
    public void clearAllSimple() {
        for (ServerCache cache : this.caches.values()) {
            if (!(cache instanceof SimpleCache)) continue;
            ((SimpleCache)cache).onClear();
        }
    }

    @Override
    public void clearAll(final boolean preserveSimple) {
        this.onCacheClearAll(preserveSimple);
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture.from((ListenableFuture)this.bootstrap.globalPlatform().submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                CompletableFuture future = CompletableFuture.completedFuture(null);
                if (JGroupsCacheManager.this.dispatcher.getChannel().isOpen()) {
                    MethodCall call = new MethodCall(METHOD_ON_CACHE_CLEAR_ALL, new Object[]{preserveSimple});
                    future = JGroupsCacheManager.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                    stopWatch.stop();
                }
                return future;
            }
        })).addCallback((FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    JGroupsCacheManager.this.logger.error("clearAll operation took too long: {}", (Object)stopWatch);
                }
            }

            public void onFailure(Throwable t) {
                if (JGroupsCacheManager.this.dispatcher.getChannel().isOpen()) {
                    JGroupsCacheManager.this.logger.error(t.getMessage(), t);
                } else {
                    JGroupsCacheManager.this.logger.warn(t.getMessage(), t);
                }
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public SimpleCache createSimpleCache(String name) {
        ServerCache cache = (ServerCache)this.caches.get(name);
        if (Objects.isNull(cache)) {
            cache = new SimpleCache(name);
            ServerCache prev = this.caches.putIfAbsent(name, cache);
            if (Objects.nonNull(prev)) {
                cache = prev;
            } else {
                new GuavaCacheMetrics(((SimpleCache)cache).get(), name, Collections.emptyList()).bindTo((MeterRegistry)this.bootstrap.meterRegistry());
            }
        }
        return (SimpleCache)cache;
    }

    public ServerCache createCache(ServerCacheConfig config) {
        String cacheKey = config.getCacheKey();
        String shortName = config.getShortName();
        ServerCacheOptions cacheOptions = config.getCacheOptions();
        ServerCacheType cacheType = config.getType();
        CurrentTenantProvider tenantProvider = config.getTenantProvider();
        QueryCacheEntryValidate queryCacheValidate = config.getQueryCacheEntryValidate();
        Object cache = (ServerCache)this.caches.get(cacheKey);
        if (Objects.isNull(cache)) {
            Config prefixedView = this.bootstrap.cfg().getPrefixedView(cacheKey);
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            for (String key : prefixedView.keys()) {
                Object rawProperty = prefixedView.getRawProperty(key);
                configMap.put(key, rawProperty);
            }
            int maxTtl = prefixedView.getInteger("max-ttl", Integer.valueOf(cacheOptions.getMaxSecsToLive()));
            int maxIdle = prefixedView.getInteger("max-idle", Integer.valueOf(cacheOptions.getMaxIdleSecs()));
            int maxSize = prefixedView.getInteger("max-size", Integer.valueOf(cacheOptions.getMaxSize()));
            int trimFrequency = (int)((Duration)this.bootstrap.props().APP_TIMER_INTERVAL.get()).toSeconds();
            ServerCacheOptions options = new ServerCacheOptions();
            options.setMaxSecsToLive(maxTtl);
            options.setMaxIdleSecs(maxIdle);
            options.setMaxSize(maxSize);
            options.setTrimFrequency(trimFrequency);
            ServerCacheConfig scc = new ServerCacheConfig(cacheType, cacheKey, shortName, options, tenantProvider, queryCacheValidate);
            ArrayList tags = Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"cacheType", (String)cacheType.name().toLowerCase()), Tag.of((String)"shortName", (String)shortName)});
            if (config.isQueryCache()) {
                cache = new JgroupsServerQueryCache(this.dispatcher, new DefaultServerCacheConfig(scc));
                ((JgroupsServerQueryCache)((Object)cache)).setBootstrap(this.bootstrap);
                ServerCache prev = this.caches.putIfAbsent(cacheKey, (ServerCache)cache);
                if (Objects.nonNull(prev)) {
                    cache = prev;
                } else {
                    this.logger.debug("created query cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
                }
            } else {
                boolean localMode;
                if (BooleanUtils.isFalse((Boolean)prefixedView.containsKey("cache-mode-local"))) {
                    if (this.bootstrap.isProdMode()) {
                        this.logger.error("cache {} is not configured", (Object)cacheKey);
                    } else {
                        throw new IllegalStateException("cache %s is not configured".formatted(cacheKey));
                    }
                }
                if (localMode = prefixedView.getBoolean("cache-mode-local", Boolean.valueOf(false)).booleanValue()) {
                    boolean neverExpire = (Boolean)this.bootstrap.props().CACHE_LOCAL_NEVER_EXPIRE.get();
                    if (neverExpire) {
                        cache = new LocalEbeanCache(cacheKey, maxSize, tenantProvider);
                        ServerCache prev = this.caches.putIfAbsent(cacheKey, (ServerCache)cache);
                        if (Objects.nonNull(prev)) {
                            cache = prev;
                        } else {
                            new GuavaCacheMetrics(((LocalEbeanCache)cache).get(), cacheKey, (Iterable)tags).bindTo((MeterRegistry)this.bootstrap.meterRegistry());
                            this.logger.debug("created local cache: {} with max size: {}", (Object)cacheKey, (Object)maxSize);
                        }
                    } else {
                        cache = new LocalEbeanCache(cacheKey, new DefaultServerCacheConfig(scc), tenantProvider);
                        ServerCache prev = this.caches.putIfAbsent(cacheKey, (ServerCache)cache);
                        if (Objects.nonNull(prev)) {
                            cache = prev;
                        } else {
                            new GuavaCacheMetrics(((LocalEbeanCache)cache).get(), cacheKey, (Iterable)tags).bindTo((MeterRegistry)this.bootstrap.meterRegistry());
                            this.logger.debug("created local cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE));
                        }
                    }
                } else {
                    boolean neverExpire = (Boolean)this.bootstrap.props().CACHE_REPLICATED_NEVER_EXPIRE.get();
                    if (neverExpire) {
                        LocalEbeanCache local = new LocalEbeanCache(cacheKey, maxSize, tenantProvider);
                        cache = new ReplicatedEbeanCache(cacheKey, this.dispatcher, local, scc);
                        ((ReplicatedEbeanCache)cache).setBootstrap(this.bootstrap);
                        ServerCache prev = this.caches.putIfAbsent(cacheKey, (ServerCache)cache);
                        if (Objects.nonNull(prev)) {
                            cache = prev;
                        } else {
                            new GuavaCacheMetrics(local.get(), cacheKey, (Iterable)tags).bindTo((MeterRegistry)this.bootstrap.meterRegistry());
                            this.logger.debug("created replicated cache: {} with max size: {}", (Object)cacheKey, (Object)maxSize);
                        }
                    } else {
                        LocalEbeanCache local = new LocalEbeanCache(cacheKey, new DefaultServerCacheConfig(scc), tenantProvider);
                        cache = new ReplicatedEbeanCache(cacheKey, this.dispatcher, local, scc);
                        ((ReplicatedEbeanCache)cache).setBootstrap(this.bootstrap);
                        ServerCache prev = this.caches.putIfAbsent(cacheKey, (ServerCache)cache);
                        if (Objects.nonNull(prev)) {
                            cache = prev;
                        } else {
                            new GuavaCacheMetrics(local.get(), cacheKey, (Iterable)tags).bindTo((MeterRegistry)this.bootstrap.meterRegistry());
                            this.logger.debug("created replicated cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE));
                        }
                    }
                }
            }
            final ServerCache tmp = Objects.requireNonNull(cache);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (tmp instanceof LocalEbeanCache) {
                        ((LocalEbeanCache)tmp).cleanUp();
                    } else if (tmp instanceof ReplicatedCache) {
                        ((ReplicatedCache)tmp).cleanUp();
                    } else if (tmp instanceof SimpleCache) {
                        ((SimpleCache)tmp).cleanUp();
                    } else if (tmp instanceof DefaultServerQueryCache) {
                        ((DefaultServerQueryCache)tmp).runEviction();
                    }
                }
            }, (long)trimFrequency, (long)trimFrequency, TimeUnit.SECONDS);
        }
        return cache;
    }

    static {
        try {
            ImmutableMap.Builder b = ImmutableMap.builder();
            b.put((Object)METHOD_ON_MODIFIED, (Object)JGroupsCacheManager.class.getMethod("onTablesModify", String.class));
            b.put((Object)METHOD_ON_CACHE_PUT, (Object)JGroupsCacheManager.class.getMethod("onCachePut", String.class, byte[].class, byte[].class));
            b.put((Object)METHOD_ON_CHANGE_REMOVE, (Object)JGroupsCacheManager.class.getMethod("onCacheRemove", String.class, byte[].class));
            b.put((Object)METHOD_ON_CACHE_CLEAR, (Object)JGroupsCacheManager.class.getMethod("onCacheClear", String.class));
            b.put((Object)METHOD_ON_CACHE_CLEAR_ALL, (Object)JGroupsCacheManager.class.getMethod("onCacheClearAll", Boolean.TYPE));
            METHODS = b.build();
        }
        catch (NoSuchMethodException err) {
            throw new Error(err);
        }
    }
}

