/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.turbospaces.ebean.LocalCache;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.cache.TenantAwareKey;
import io.ebean.config.CurrentTenantProvider;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEbeanCache
implements LocalCache,
Supplier<Cache<Object, Object>> {
    private static EnumSet<RemovalCause> REASONS = EnumSet.of(RemovalCause.EXPIRED, RemovalCause.SIZE);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String cacheKey;
    private final Cache<Object, Object> cache;
    private final TenantAwareKey tenantAwareKey;

    public LocalEbeanCache(String cacheKey, int maxSize, CurrentTenantProvider tenantProvider) {
        this.cacheKey = Objects.requireNonNull(cacheKey);
        this.tenantAwareKey = new TenantAwareKey(tenantProvider);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).recordStats().build();
    }

    public LocalEbeanCache(final String cacheKey, DefaultServerCacheConfig cfg, CurrentTenantProvider tenantProvider) {
        this.cacheKey = Objects.requireNonNull(cacheKey);
        this.tenantAwareKey = new TenantAwareKey(tenantProvider);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cfg.getMaxSize()).expireAfterAccess((long)cfg.getMaxIdleSecs(), TimeUnit.SECONDS).expireAfterWrite((long)cfg.getMaxSecsToLive(), TimeUnit.SECONDS).recordStats().removalListener((RemovalListener)new RemovalListener<Object, Object>(){

            public void onRemoval(RemovalNotification<Object, Object> notification) {
                if (Objects.nonNull(notification.getCause()) && REASONS.contains(notification.getCause())) {
                    String type = notification.getCause().name().toLowerCase().intern();
                    LocalEbeanCache.this.logger.trace("onRemoval({}): {} {}", new Object[]{cacheKey, type, notification});
                }
            }
        }).build();
    }

    public Object get(Object id) {
        return this.cache.getIfPresent(this.key(id));
    }

    public void put(Object id, Object value) {
        this.cache.put(this.key(id), value);
    }

    public void remove(Object id) {
        this.cache.invalidate(this.key(id));
    }

    public int size() {
        return (int)this.cache.size();
    }

    public int hitRatio() {
        return (int)(this.cache.stats().hitRate() * 100.0);
    }

    public ServerCacheStatistics statistics(boolean reset) {
        CacheStats stats = this.cache.stats();
        ServerCacheStatistics scs = new ServerCacheStatistics();
        scs.setCacheName(this.cacheKey);
        scs.setEvictCount(stats.evictionCount());
        scs.setHitCount(stats.hitCount());
        scs.setMissCount(stats.missCount());
        scs.setSize(this.size());
        return scs;
    }

    public void clear() {
        this.logger.debug("clearing {}(items={})", (Object)this.cacheKey, (Object)this.cache.size());
        this.cache.invalidateAll();
        this.cleanUp();
    }

    @Override
    public int onClear() {
        long size = this.cache.size();
        this.clear();
        return (int)size;
    }

    @Override
    public void cleanUp() {
        this.cache.cleanUp();
    }

    @Override
    public Cache<Object, Object> get() {
        return this.cache;
    }

    public String toString() {
        return this.cacheKey;
    }

    protected Object key(Object key) {
        return this.tenantAwareKey.key(key).toString();
    }
}

