/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.ebean.JGroupsCacheManager;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import io.vavr.CheckedFunction0;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JgroupsServerQueryCache
extends DefaultServerQueryCache
implements BootstrapAware {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RpcDispatcher dispatcher;
    private Bootstrap bootstrap;

    public JgroupsServerQueryCache(RpcDispatcher dispatcher, DefaultServerCacheConfig config) {
        super(config);
        this.dispatcher = dispatcher;
    }

    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = Objects.requireNonNull(bootstrap);
    }

    public void clear() {
        this.onClear();
        final StopWatch stopWatch = StopWatch.createStarted();
        FluentFuture.from((ListenableFuture)this.bootstrap.globalPlatform().submit((CheckedFunction0)new CheckedFunction0<CompletableFuture<RspList<Object>>>(){

            public CompletableFuture<RspList<Object>> apply() throws Throwable {
                MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CACHE_CLEAR, new Object[]{JgroupsServerQueryCache.this.name});
                CompletableFuture future = JgroupsServerQueryCache.this.dispatcher.callRemoteMethodsWithFuture(null, call, RequestOptions.ASYNC());
                stopWatch.stop();
                return future;
            }
        })).addCallback((FutureCallback)new FutureCallback<CompletableFuture<RspList<Object>>>(){

            public void onSuccess(CompletableFuture<RspList<Object>> result) {
                JgroupsServerQueryCache.this.log.info("cleared query cache {} on remote nodes in: {}", (Object)JgroupsServerQueryCache.this.name, (Object)stopWatch);
                long time = stopWatch.getTime(TimeUnit.SECONDS);
                if (time > 0L) {
                    JgroupsServerQueryCache.this.log.error("clear operation took too long: {}", (Object)stopWatch);
                }
            }

            public void onFailure(Throwable t) {
                JgroupsServerQueryCache.this.log.error(t.getMessage(), t);
            }
        }, MoreExecutors.directExecutor());
    }

    public void onClear() {
        super.clear();
    }
}

