/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ebean.Account;
import com.turbospaces.ebean.AccountBalance;
import com.turbospaces.ebean.AccountBalanceId;
import com.turbospaces.ebean.AccountBalanceSnapshot;
import com.turbospaces.ebean.AccountBalanceSnapshotId;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.DefaultEbeanCacheConfigurer;
import com.turbospaces.ebean.EbeanDatabaseConfig;
import com.turbospaces.ebean.EbeanFactoryBean;
import com.turbospaces.ebean.FraudJson;
import com.turbospaces.ebean.GameplayInfo;
import com.turbospaces.ebean.JGroupCacheManagerFactoryBean;
import com.turbospaces.ebean.JpaManager;
import com.turbospaces.ebean.TracedEbeanTransaction;
import com.turbospaces.ebean.UTMTemplate;
import com.turbospaces.ebean.query.QAccount;
import com.turbospaces.ebean.query.QAccountBalance;
import com.turbospaces.jdbc.HikariDataSourceFactoryBean;
import com.turbospaces.jgroups.JGroupsFactoryBean;
import com.turbospaces.plugins.FlywayBootstrapInitializer;
import com.turbospaces.ups.UPSs;
import io.ebean.Database;
import io.ebean.ProfileLocation;
import io.ebean.Transaction;
import io.ebean.bean.EnhancedTransactional;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import javax.sql.DataSource;
import org.awaitility.Awaitility;
import org.jgroups.JChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;

public class CompositeKeyTest
implements EnhancedTransactional {
    private final Integer DELAY_AND_PERIOD_OF_CACHE_EXECUTIONS_MS = 10;
    private static /* synthetic */ ProfileLocation _$ebpq0;
    private static /* synthetic */ ProfileLocation _$ebpq1;
    private static /* synthetic */ ProfileLocation _$ebpq2;
    private static /* synthetic */ ProfileLocation _$ebpq3;
    private static /* synthetic */ ProfileLocation _$ebpq4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Throwable {
        MockCloud builder = MockCloud.newMock();
        ApplicationConfig cfg = builder.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        DefaultEbeanCacheConfigurer mngr = new DefaultEbeanCacheConfigurer(props);
        mngr.setLocal(UTMTemplate.class);
        mngr.setLocal(Account.class);
        mngr.setLocal(AccountBalance.class);
        mngr.setLocal(AccountBalanceSnapshot.class);
        mngr.setLocal(Account.class, QAccount.alias()._balances());
        mngr.setLocal(Account.class, QAccount.alias()._utmTemplates());
        mngr.setLocal(AccountBalance.class, QAccountBalance.alias()._snapshots());
        mngr.setMaxSize(Account.class, 1);
        mngr.setMaxSize(Account.class, QAccount.alias()._balances(), 1);
        mngr.setMaxSize(UTMTemplate.class, 8);
        mngr.setMaxSize(AccountBalance.class, 10);
        mngr.setMaxSize(AccountBalance.class, QAccountBalance.alias()._snapshots(), 10);
        mngr.setMaxSize(AccountBalanceSnapshot.class, 30);
        mngr.setMaxSize(Account.class, QAccount.alias()._utmTemplates(), Integer.MAX_VALUE);
        mngr.setMaxSizeQuery(Account.class, 1);
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg), new Class[]{AppConfig.class});
        try {
            QAccountBalance query;
            bootstrap.withH2(true, bootstrap.spaceName());
            bootstrap.cfg().setDefaultProperty(props.CACHE_METRICS_REPORT_INTERVAL.getKey(), (Object)Duration.ofMillis(this.DELAY_AND_PERIOD_OF_CACHE_EXECUTIONS_MS.intValue()));
            ServiceInfo ownerUps = UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)"h2-owner");
            bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new FlywayBootstrapInitializer(ownerUps, new String[]{"CORE"}));
            ConfigurableApplicationContext applicationContext = bootstrap.run(new String[0]);
            Database ebean = (Database)applicationContext.getBean(Database.class);
            Account account = new Account();
            account.setId(System.currentTimeMillis());
            account.setUsername("username_" + account.getId());
            account.setFirstName("f_" + account.getId());
            account.setLastName("l_" + account.getId());
            account.setAge(18);
            account.setBirthDate(LocalDate.now(ZoneOffset.UTC).minusYears(account.getAge()));
            ebean.save((Object)account);
            AccountBalance balance = new AccountBalance(account, "USD");
            balance.setAmount(BigDecimal.ONE);
            AccountBalanceSnapshot snapshot1 = new AccountBalanceSnapshot(balance, LocalDate.now(ZoneOffset.UTC));
            AccountBalanceSnapshot snapshot2 = new AccountBalanceSnapshot(balance, LocalDate.now(ZoneOffset.UTC).plusDays(1L));
            balance.getSnapshots().add(snapshot1);
            balance.getSnapshots().add(snapshot2);
            ebean.save((Object)balance);
            QAccountBalance q = (QAccountBalance)((Object)new QAccountBalance(ebean).setProfileLocation(_$ebpq0));
            q.setId(balance.getPk());
            q.findList();
            try (Transaction tx1 = ebean.beginTransaction();){
                query = (QAccountBalance)((Object)((QAccountBalance)((Object)((QAccountBalance)((Object)new QAccountBalance(ebean).setProfileLocation(_$ebpq1))).usingTransaction(tx1))).setUseQueryCache(true));
                query._amount().ge((Object)BigDecimal.ONE);
                query.findList();
            }
            try (Transaction tx2 = ebean.beginTransaction();){
                query = (QAccountBalance)((Object)((QAccountBalance)((Object)((QAccountBalance)((Object)new QAccountBalance(ebean).setProfileLocation(_$ebpq2))).usingTransaction(tx2))).setUseQueryCache(true));
                query._amount().ge((Object)BigDecimal.ONE);
                query.findList();
            }
            try (Transaction tx3 = ebean.beginTransaction();){
                query = (QAccountBalance)((Object)((QAccountBalance)((Object)((QAccountBalance)((Object)new QAccountBalance(ebean).setProfileLocation(_$ebpq3))).usingTransaction(tx3))).setUseQueryCache(true));
                query._amount().ge((Object)BigDecimal.ONE);
                query.findList();
            }
            Assertions.assertEquals((double)1.0, (double)bootstrap.meterRegistry().get("cache.size").tag("cache", "com.turbospaces.ebean.AccountBalance_B").gauge().value());
            Awaitility.await().until(() -> CompositeKeyTest.checkQueryMetrics(bootstrap, "query_cache.hits", 2.0) && CompositeKeyTest.checkQueryMetrics(bootstrap, "query_cache.puts", 1.0) && CompositeKeyTest.checkQueryMetrics(bootstrap, "query_cache.evicts", 0.0));
            account.setAge(21);
            ebean.save((Object)account);
            Thread.sleep(0L);
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryCacheInvalidation() throws Throwable {
        MockCloud builder = MockCloud.newMock();
        ApplicationConfig cfg = builder.build();
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg), new Class[]{AppConfig.class});
        try {
            BigDecimal sum;
            int i;
            bootstrap.withH2(true, bootstrap.spaceName());
            ServiceInfo ownerUps = UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)"h2-owner");
            bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new FlywayBootstrapInitializer(ownerUps, new String[]{"CORE"}));
            ConfigurableApplicationContext applicationContext = bootstrap.run(new String[0]);
            JpaManager ebean = (JpaManager)applicationContext.getBean(JpaManager.class);
            Account account = new Account();
            account.setId(System.currentTimeMillis());
            String username = "username_" + account.getId();
            account.setUsername(username);
            account.setFirstName("f_" + account.getId());
            account.setLastName("l_" + account.getId());
            account.setAge(18);
            account.setBirthDate(LocalDate.now(ZoneOffset.UTC).minusYears(account.getAge()));
            ebean.save((Object)account);
            AccountBalance balance1 = new AccountBalance(account, "USD");
            balance1.setAmount(BigDecimal.ONE);
            ebean.save((Object)balance1);
            AccountBalance balance2 = new AccountBalance(account, "EUR");
            balance2.setAmount(BigDecimal.ONE);
            ebean.save((Object)balance2);
            balance1.setAmount(BigDecimal.valueOf(2L));
            balance2.setAmount(BigDecimal.valueOf(3L));
            ebean.save((Object)balance1);
            ebean.save((Object)balance2);
            for (i = 0; i < 10; ++i) {
                sum = BigDecimal.ZERO;
                for (Long id : CompositeKeyTest.getAccounts(ebean, username)) {
                    for (AccountBalance it : ((Account)ebean.find(Account.class, (Object)id)).getBalances()) {
                        sum = sum.add(it.getAmount());
                    }
                }
                Assertions.assertEquals((long)5L, (long)sum.longValue());
            }
            balance1.setAmount(BigDecimal.valueOf(7L));
            balance2.setAmount(BigDecimal.valueOf(11L));
            ebean.save((Object)balance1);
            ebean.save((Object)balance2);
            for (i = 0; i < 10; ++i) {
                sum = BigDecimal.ZERO;
                for (Long id : CompositeKeyTest.getAccounts(ebean, username)) {
                    for (AccountBalance it : ((Account)ebean.find(Account.class, (Object)id)).getBalances()) {
                        sum = sum.add(it.getAmount());
                    }
                }
                Assertions.assertEquals((long)18L, (long)sum.longValue());
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }

    private static List<Long> getAccounts(JpaManager ebean, String username) throws Exception {
        try (TracedEbeanTransaction tx = ebean.newTransaction();){
            QAccount query = (QAccount)((Object)((QAccount)((Object)((QAccount)((Object)new QAccount((Database)ebean).setProfileLocation(_$ebpq4))).usingTransaction((Transaction)tx))).setUseQueryCache(true));
            query._username().eq((Object)username);
            List list = query.findIds();
            return list;
        }
    }

    private static boolean checkQueryMetrics(SimpleBootstrap bootstrap, String queryName, double expectedCount) {
        try {
            return bootstrap.meterRegistry().get(queryName).tag("name", "com.turbospaces.ebean.AccountBalance_Q").counter().count() == expectedCount;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static /* synthetic */ void _$initProfileLocations() {
        _$ebpq0 = ProfileLocation.create();
        _$ebpq1 = ProfileLocation.create();
        _$ebpq2 = ProfileLocation.create();
        _$ebpq3 = ProfileLocation.create();
        _$ebpq4 = ProfileLocation.create();
    }

    static {
        CompositeKeyTest._$initProfileLocations();
    }

    @Configurable
    public static class AppConfig
    extends AbstractBootstrapAware {
        @Bean
        public HikariDataSourceFactoryBean ds() {
            ServiceInfo appUps = UPSs.findRequiredServiceInfoByName((Bootstrap)this.bootstrap, (String)"h2-app");
            return new HikariDataSourceFactoryBean(appUps);
        }

        @Bean
        public JGroupsFactoryBean jgroups() {
            return new JGroupsFactoryBean();
        }

        @Bean
        public JGroupCacheManagerFactoryBean cacheManager(JGroupsFactoryBean factory) throws Exception {
            return new JGroupCacheManagerFactoryBean((JChannel)factory.getObject());
        }

        @Bean
        public EbeanDatabaseConfig ebeanConfig(HikariDataSourceFactoryBean factory) throws Exception {
            EbeanDatabaseConfig cfg = new EbeanDatabaseConfig((DataSource)factory.getObject(), this.bootstrap.props());
            cfg.addClass(Account.class);
            cfg.addClass(GameplayInfo.class);
            cfg.addClass(FraudJson.class);
            cfg.addClass(UTMTemplate.class);
            cfg.addClass(AccountBalance.class);
            cfg.addClass(AccountBalanceId.class);
            cfg.addClass(AccountBalanceSnapshot.class);
            cfg.addClass(AccountBalanceSnapshotId.class);
            cfg.setLocal(UTMTemplate.class);
            cfg.setLocal(Account.class);
            cfg.setLocal(AccountBalance.class);
            cfg.setLocal(AccountBalanceSnapshot.class);
            cfg.setLocal(Account.class, QAccount.alias()._balances());
            cfg.setLocal(Account.class, QAccount.alias()._utmTemplates());
            cfg.setLocal(AccountBalance.class, QAccountBalance.alias()._snapshots());
            return cfg;
        }

        @Bean
        public EbeanFactoryBean ebean(EbeanDatabaseConfig config, JGroupCacheManagerFactoryBean cache) throws Exception {
            return new EbeanFactoryBean(config, (CacheManager)cache.getObject());
        }
    }
}

