package com.turbospaces.ebean;

import java.util.Objects;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.springframework.beans.factory.config.AbstractFactoryBean;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;

public class JGroupCacheManagerFactoryBean extends AbstractFactoryBean<CacheManager> implements BootstrapAware {
    private final RpcDispatcher dispatcher = new RpcDispatcher();
    private final JChannel jchannel;
    private Bootstrap bootstrap;

    public JGroupCacheManagerFactoryBean(JChannel jchannel) {
        this.jchannel = Objects.requireNonNull(jchannel);
    }
    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }
    @Override
    public Class<?> getObjectType() {
        return CacheManager.class;
    }
    @Override
    protected CacheManager createInstance() throws Exception {
        for (;;) {
            try {
                JGroupsCacheManager manager = new JGroupsCacheManager(dispatcher);
                manager.setBootstrap(bootstrap);

                dispatcher.setAsynDispatching(true);
                dispatcher.setChannel(jchannel);
                dispatcher.setServerObject(manager);
                dispatcher.setMethodLookup(manager);
                dispatcher.start();

                return manager;
            } catch (Throwable err) {
                ExceptionUtils.wrapAndThrow(err);
            }
        }
    }
    @Override
    protected void destroyInstance(CacheManager instance) throws Exception {
        dispatcher.close();
    }
}
