/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.ebean.JGroupsCacheManager;
import com.turbospaces.ebean.ReplicatedCache;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.cache.ServerCacheType;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.cache.CachedManyIds;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedEbeanCache
implements ReplicatedCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String cacheKey;
    private final RpcDispatcher dispatcher;
    private final RequestOptions requestOptions;
    private final ServerCache local;
    private final ServerCacheConfig config;

    public ReplicatedEbeanCache(String cacheKey, RpcDispatcher dispatcher, RequestOptions requestOptions, ServerCache local, ServerCacheConfig config) {
        this.cacheKey = Objects.requireNonNull(cacheKey);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.requestOptions = Objects.requireNonNull(requestOptions);
        this.local = Objects.requireNonNull(local);
        this.config = Objects.requireNonNull(config);
    }

    public int size() {
        return this.local.size();
    }

    public Object get(Object id) {
        return this.local.get(id);
    }

    public int hitRatio() {
        return this.local.hitRatio();
    }

    public ServerCacheStatistics statistics(boolean reset) {
        return this.local.statistics(reset);
    }

    public void put(Object id, Object value) {
        this.local.put(id, value);
        byte[] keyAsBytes = SerializationUtils.serialize((Serializable)((Serializable)id));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        switch (this.config.getType()) {
            case NATURAL_KEY: {
                ObjectOutputStream oos;
                try {
                    oos = new ObjectOutputStream(out);
                    try {
                        oos.writeObject(value);
                        oos.flush();
                    }
                    finally {
                        oos.close();
                    }
                }
                catch (IOException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            case BEAN: {
                CachedBeanData data;
                ObjectOutputStream oos;
                try {
                    oos = new ObjectOutputStream(out);
                    try {
                        data = (CachedBeanData)value;
                        data.writeExternal((ObjectOutput)oos);
                        oos.flush();
                    }
                    finally {
                        oos.close();
                    }
                }
                catch (IOException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            case COLLECTION_IDS: {
                CachedBeanData data;
                ObjectOutputStream oos;
                try {
                    oos = new ObjectOutputStream(out);
                    try {
                        data = (CachedManyIds)value;
                        data.writeExternal((ObjectOutput)oos);
                        oos.flush();
                    }
                    finally {
                        oos.close();
                    }
                }
                catch (IOException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected cache type: " + this.config.getType());
            }
        }
        try {
            this.logger.debug("putting {} entry on remote nodes by key: {} value: {}", new Object[]{this.cacheKey, id, value});
            MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CACHE_PUT, new Object[]{this.cacheKey, keyAsBytes, out.toByteArray()});
            RspList l = this.dispatcher.callRemoteMethods(null, call, this.requestOptions);
            if (Objects.nonNull(l)) {
                ReplicatedCache.log(this.logger, (RspList<Object>)l);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.wrapAndThrow((Throwable)t);
        }
    }

    public void remove(Object id) {
        this.local.remove(id);
        try {
            this.logger.debug("removing {} entry on remote nodes by key: {} ...", (Object)this.cacheKey, id);
            byte[] keyAsBytes = SerializationUtils.serialize((Serializable)((Serializable)id));
            MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CHANGE_REMOVE, new Object[]{this.cacheKey, keyAsBytes});
            RspList l = this.dispatcher.callRemoteMethods(null, call, this.requestOptions);
            if (Objects.nonNull(l)) {
                ReplicatedCache.log(this.logger, (RspList<Object>)l);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.wrapAndThrow((Throwable)t);
        }
    }

    public void clear() {
        this.local.clear();
        this.logger.debug("clearing {} on remote nodes ...", (Object)this.cacheKey);
        try {
            MethodCall call = new MethodCall(JGroupsCacheManager.METHOD_ON_CACHE_CLEAR, new Object[]{this.cacheKey});
            RspList l = this.dispatcher.callRemoteMethods(null, call, this.requestOptions);
            if (Objects.nonNull(l)) {
                ReplicatedCache.log(this.logger, (RspList<Object>)l);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.wrapAndThrow((Throwable)t);
        }
    }

    @Override
    public void onPut(byte[] keyData, byte[] valueData) {
        Object key = SerializationUtils.deserialize((byte[])keyData);
        ByteArrayInputStream is = new ByteArrayInputStream(valueData);
        switch (this.config.getType()) {
            case NATURAL_KEY: {
                try (ObjectInputStream ois = new ObjectInputStream(is);){
                    Object read = ois.readObject();
                    this.logger.debug("onPut {} by key: {} value: {}", new Object[]{this.cacheKey, key, read});
                    this.local.put(key, read);
                }
                catch (IOException | ClassNotFoundException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            case BEAN: {
                try (ObjectInputStream ois = new ObjectInputStream(is);){
                    CachedBeanData read = new CachedBeanData();
                    read.readExternal((ObjectInput)ois);
                    this.logger.debug("onPut {} by key: {} bean value: {}", new Object[]{this.cacheKey, key, read});
                    this.local.put(key, (Object)read);
                }
                catch (IOException | ClassNotFoundException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            case COLLECTION_IDS: {
                try (ObjectInputStream ois = new ObjectInputStream(is);){
                    CachedManyIds read = new CachedManyIds();
                    read.readExternal((ObjectInput)ois);
                    this.logger.debug("onPut {} by key: {} ids value: {}", new Object[]{this.cacheKey, key, read});
                    this.local.put(key, (Object)read);
                }
                catch (IOException | ClassNotFoundException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected cache type: " + this.config.getType());
            }
        }
    }

    @Override
    public void onRemove(byte[] data) {
        Object key = SerializationUtils.deserialize((byte[])data);
        this.logger.debug("onRemove {} by key: {}", (Object)this.cacheKey, key);
        this.local.remove(key);
    }

    @Override
    public int onClear() {
        this.logger.debug("onClear {}", (Object)this.cacheKey);
        int size = this.local.size();
        this.local.clear();
        return size;
    }

    @Override
    public ServerCacheType type() {
        return this.config.getType();
    }
}

