/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.ebean.Account;
import com.turbospaces.ebean.AccountBalance;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.FraudJson;
import com.turbospaces.ebean.GameplayInfo;
import com.turbospaces.ebean.JpaManager;
import com.turbospaces.ebean.TracedEbeanTransaction;
import com.turbospaces.ebean.query.QAccount;
import io.ebean.Transaction;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheType;
import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.awaitility.Awaitility;
import org.awaitility.core.ThrowingRunnable;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.InitializingBean;

public class CacheBean
extends AbstractBootstrapAware
implements InitializingBean {
    private final JpaManager ebean;
    private final CacheManager manager;

    @Inject
    public CacheBean(JpaManager ebean, CacheManager manager) {
        this.ebean = ebean;
        this.manager = manager;
    }

    public void afterPropertiesSet() throws Exception {
        TracedEbeanTransaction tx;
        int i;
        Account account;
        TracedEbeanTransaction tx2;
        String aname = Account.class.getName();
        String abname = AccountBalance.class.getName();
        long id = Math.abs(((Object)((Object)this)).hashCode());
        try {
            tx2 = this.ebean.newTransaction();
            try {
                account = new Account();
                account.setId(id);
                account.setFraud(new FraudJson(Collections.emptyMap()));
                account.setUsername("username_" + account.getId());
                account.setFirstName("f_" + account.getId());
                account.setLastName("l_" + account.getId());
                account.setDetails(Collections.emptyMap());
                AccountBalance balance1 = new AccountBalance(account, "USD");
                balance1.setAmount(BigDecimal.TEN);
                account.getBalances().add(balance1);
                AccountBalance balance2 = new AccountBalance(account, "EUR");
                balance2.setAmount(BigDecimal.ONE);
                account.getBalances().add(balance2);
                AccountBalance balance3 = new AccountBalance(account, "UAH");
                balance3.setAmount(BigDecimal.ONE);
                account.getBalances().add(balance3);
                this.ebean.save((Object)account);
                tx2.commit();
            }
            finally {
                if (tx2 != null) {
                    tx2.close();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            tx2 = this.ebean.newTransaction();
            try {
                for (Object it : this.ebean.find(Account.class).findList()) {
                    ((Account)it).setAge(((Account)it).getAge() + 1);
                    ((Account)it).setGameplayInfo(new GameplayInfo());
                    this.ebean.save(it, (Transaction)tx2);
                }
                tx2.commit();
            }
            finally {
                if (tx2 != null) {
                    tx2.close();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        for (i = 0; i < 10; ++i) {
            this.logger.debug("it ::: {}", (Object)i);
            tx = this.ebean.newReadOnlyTransaction();
            try {
                tx.setReadOnly(true);
                account = (Account)this.ebean.find(Account.class, (Object)id);
                account.getBalances().size();
                for (AccountBalance balance : account.getBalances()) {
                    balance.getAmount().toString();
                }
                continue;
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        for (i = 0; i < 10; ++i) {
            tx = this.ebean.newReadOnlyTransaction();
            try {
                tx.setReadOnly(true);
                Set accounts = this.ebean.createQuery(Account.class).setUseQueryCache(true).findSet();
                accounts.size();
                continue;
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        try (TracedEbeanTransaction tx3 = this.ebean.newTransaction();){
            account = (Account)this.ebean.find(Account.class, (Object)id);
            account.setAge(32);
            this.ebean.save((Object)account);
            tx3.commit();
        }
        Awaitility.await().atMost(Duration.ofSeconds(10L)).untilAsserted(new ThrowingRunnable(){

            public void run() throws Throwable {
            }
        });
        ServerCache aCache = this.manager.getCache(aname + ServerCacheType.BEAN.code());
        ServerCache bCache = this.manager.getCache(abname + ServerCacheType.BEAN.code());
        ServerCache cCache = this.manager.getCache(aname + "." + QAccount.alias()._balances().toString() + ServerCacheType.COLLECTION_IDS.code());
        Assertions.assertEquals((int)1, (int)aCache.size());
        Assertions.assertEquals((int)2, (int)bCache.size());
        Assertions.assertEquals((int)1, (int)cCache.size());
        this.ebean.cacheManager().beanCache(Account.class).clear();
        Assertions.assertEquals((int)0, (int)aCache.size());
        Assertions.assertEquals((int)2, (int)bCache.size());
        Assertions.assertEquals((int)1, (int)cCache.size());
        this.ebean.cacheManager().beanCache(AccountBalance.class).clear();
        Assertions.assertEquals((int)0, (int)bCache.size());
        this.ebean.cacheManager().clear(Account.class);
        Assertions.assertEquals((int)0, (int)cCache.size());
    }
}

