package com.turbospaces.ebean;

import java.util.Objects;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jgroups.JChannel;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.springframework.beans.factory.config.AbstractFactoryBean;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;

import io.ebean.BackgroundExecutor;

public class JGroupCacheManagerFactoryBean extends AbstractFactoryBean<CacheManager> implements BootstrapAware {
    private final RpcDispatcher dispatcher = new RpcDispatcher();
    private final JChannel jchannel;
    private BackgroundExecutor backgroundExecutor;
    private Bootstrap bootstrap;

    public JGroupCacheManagerFactoryBean(JChannel jchannel) {
        this.jchannel = Objects.requireNonNull(jchannel);
    }
    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }
    public void setBackgroundExecutor(BackgroundExecutor backgroundExecutor) {
        this.backgroundExecutor = backgroundExecutor;
    }
    @Override
    public Class<?> getObjectType() {
        return CacheManager.class;
    }
    @Override
    protected CacheManager createInstance() throws Exception {
        for (;;) {
            try {
                JGroupsCacheManager manager = new JGroupsCacheManager(dispatcher, bootstrap.isDevMode() ? RequestOptions.SYNC() : RequestOptions.ASYNC());
                manager.setBootstrap(bootstrap);
                if (Objects.nonNull(backgroundExecutor)) {
                    manager.setBackgroundExecutor(backgroundExecutor);
                }

                dispatcher.setChannel(jchannel);
                dispatcher.setServerObject(manager);
                dispatcher.setMethodLookup(manager);
                dispatcher.start();

                return manager;
            } catch (Throwable err) {
                ExceptionUtils.wrapAndThrow(err);
            }
        }
    }
    @Override
    protected void destroyInstance(CacheManager instance) throws Exception {
        dispatcher.close();
    }
}
