/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.collect.Sets;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ebean.Account;
import com.turbospaces.ebean.AccountBalance;
import com.turbospaces.ebean.AccountBalanceId;
import com.turbospaces.ebean.AccountBalanceSnapshot;
import com.turbospaces.ebean.AccountBalanceSnapshotId;
import com.turbospaces.ebean.AccountSeq;
import com.turbospaces.ebean.CacheBean;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.EbeanDatabaseConfig;
import com.turbospaces.ebean.EbeanFactoryBean;
import com.turbospaces.ebean.EbeanJpaManager;
import com.turbospaces.ebean.FraudJson;
import com.turbospaces.ebean.GameplayInfo;
import com.turbospaces.ebean.JGroupCacheManagerFactoryBean;
import com.turbospaces.ebean.JpaManager;
import com.turbospaces.ebean.RollbackBean;
import com.turbospaces.ebean.UTMTemplate;
import com.turbospaces.ebean.query.QAccount;
import com.turbospaces.jdbc.HikariDataSourceFactoryBean;
import com.turbospaces.jgroups.JGroupsFactoryBean;
import com.turbospaces.plugins.FlywayBootstrapInitializer;
import com.turbospaces.ups.H2ServiceInfo;
import com.turbospaces.ups.UPSs;
import io.ebean.Transaction;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import java.util.Collections;
import java.util.HashSet;
import javax.sql.DataSource;
import org.jgroups.JChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;

public class EbeanInfinispanPluginTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Throwable {
        MockCloud builder = MockCloud.newMock();
        ApplicationConfig cfg = builder.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props, new Class[]{AppConfig.class});
        bootstrap.withH2(true, bootstrap.spaceName());
        H2ServiceInfo ownerUps = (H2ServiceInfo)UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)"h2-owner");
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new FlywayBootstrapInitializer((ServiceInfo)ownerUps, new String[]{"CORE"}));
        ConfigurableApplicationContext applicationContext = bootstrap.run(new String[0]);
        try {
            EbeanJpaManager ebean = (EbeanJpaManager)applicationContext.getBean(JpaManager.class);
            HashSet set = Sets.newHashSet();
            long now = System.currentTimeMillis();
            try (Transaction tx = ebean.beginTransaction();){
                for (int i = 0; i < 16384; ++i) {
                    PlatformIdGenerator generator = ebean.idGenerator(AccountSeq.class);
                    Account account = new Account();
                    long nextId = (Long)generator.nextId(tx);
                    Assertions.assertTrue((boolean)set.add(nextId));
                    account.setId(now + nextId);
                    account.setFraud(new FraudJson(Collections.emptyMap()));
                    account.setUsername("username_" + account.getId());
                    account.setFirstName("f_" + account.getId());
                    account.setLastName("l_" + account.getId());
                    account.setDetails(Collections.emptyMap());
                    ebean.save((Object)account, tx);
                }
                tx.commit();
            }
            long min = (Long)set.stream().min(Long::compare).get();
            long max = (Long)set.stream().max(Long::compare).get();
            Assertions.assertEquals((long)min, (long)1L);
            Assertions.assertEquals((long)max, (long)16384L);
            Assertions.assertEquals((int)ebean.idGenerators().size(), (int)1);
        }
        finally {
            bootstrap.shutdown();
        }
    }

    @Configurable
    public static class AppConfig
    extends AbstractBootstrapAware {
        @Bean
        public HikariDataSourceFactoryBean ds() {
            ServiceInfo appUps = UPSs.findRequiredServiceInfoByName((Bootstrap)this.bootstrap, (String)"h2-app");
            return new HikariDataSourceFactoryBean(appUps);
        }

        @Bean
        public JGroupsFactoryBean jgroups() {
            return new JGroupsFactoryBean();
        }

        @Bean
        public JGroupCacheManagerFactoryBean cacheManager(JGroupsFactoryBean factory) throws Exception {
            return new JGroupCacheManagerFactoryBean((JChannel)factory.getObject());
        }

        @Bean
        public EbeanDatabaseConfig ebeanConfig(HikariDataSourceFactoryBean factory) throws Exception {
            EbeanDatabaseConfig cfg = new EbeanDatabaseConfig((DataSource)factory.getObject(), this.bootstrap.props());
            cfg.addClass(AccountSeq.class);
            cfg.addClass(Account.class);
            cfg.addClass(GameplayInfo.class);
            cfg.addClass(FraudJson.class);
            cfg.addClass(AccountBalance.class);
            cfg.addClass(AccountBalanceId.class);
            cfg.addClass(AccountBalanceSnapshot.class);
            cfg.addClass(AccountBalanceSnapshotId.class);
            cfg.addClass(UTMTemplate.class);
            cfg.setMaxSize(Account.class, 1);
            cfg.setMaxSizeQuery(Account.class, 1);
            cfg.setMaxSize(Account.class, QAccount.alias()._balances(), 1);
            cfg.setMaxSize(UTMTemplate.class, 8);
            cfg.setMaxSize(AccountBalance.class, 2);
            cfg.setMaxSize(AccountBalanceSnapshot.class, 4);
            cfg.setMaxSize(Account.class, QAccount.alias()._utmTemplates(), Integer.MAX_VALUE);
            return cfg;
        }

        @Bean
        public EbeanFactoryBean ebean(EbeanDatabaseConfig config, JGroupCacheManagerFactoryBean cache) throws Exception {
            return new EbeanFactoryBean(config, (CacheManager)cache.getObject());
        }

        @Bean
        public RollbackBean rollbackBean(EbeanFactoryBean ebean, CacheManager manager) throws Exception {
            return new RollbackBean((JpaManager)ebean.getObject(), manager);
        }

        @Bean
        public CacheBean cacheBean(EbeanFactoryBean ebean, CacheManager manager) throws Exception {
            return new CacheBean((JpaManager)ebean.getObject(), manager);
        }
    }
}

