/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.netflix.archaius.api.Config;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.LocalEbeanCache;
import com.turbospaces.ebean.SimpleCache;
import io.ebean.BackgroundExecutor;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.cache.ServerCacheType;
import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class MockCacheManager
extends AbstractBootstrapAware
implements CacheManager {
    private final Map<String, ServerCache> caches = new ConcurrentHashMap<String, ServerCache>();
    private BackgroundExecutor executor;

    @Override
    public void setBackgroundExecutor(BackgroundExecutor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    public ServerCacheFactory create(DatabaseConfig config, BackgroundExecutor backgroupExecutor) {
        this.setBackgroundExecutor(backgroupExecutor);
        return this;
    }

    public ServerCacheNotify createCacheNotify(ServerCacheNotify listener) {
        return new ServerCacheNotify(){

            public void notify(ServerCacheNotification notification) {
            }
        };
    }

    @Override
    public SimpleCache createSimpleCache(String name) {
        ServerCache prev;
        ServerCache cache = this.caches.get(name);
        if (Objects.isNull(cache) && Objects.nonNull(prev = this.caches.putIfAbsent(name, cache = new SimpleCache(name)))) {
            cache = prev;
        }
        return (SimpleCache)cache;
    }

    public ServerCache createCache(ServerCacheConfig config) {
        String cacheKey = config.getCacheKey();
        String shortName = config.getShortName();
        ServerCacheOptions cacheOptions = config.getCacheOptions();
        ServerCacheType cacheType = config.getType();
        CurrentTenantProvider tenantProvider = config.getTenantProvider();
        QueryCacheEntryValidate queryCacheValidate = config.getQueryCacheEntryValidate();
        ServerCache cache = this.caches.get(cacheKey);
        if (Objects.isNull(cache)) {
            Config prefixedView = this.bootstrap.cfg().getPrefixedView(cacheKey);
            Iterator it = prefixedView.getKeys();
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object rawProperty = prefixedView.getRawProperty(key);
                configMap.put(key, rawProperty);
            }
            int maxTtl = prefixedView.getInteger("max-ttl", Integer.valueOf(cacheOptions.getMaxSecsToLive()));
            int maxIdle = prefixedView.getInteger("max-idle", Integer.valueOf(cacheOptions.getMaxIdleSecs()));
            int maxSize = prefixedView.getInteger("max-size", Integer.valueOf(cacheOptions.getMaxSize()));
            int trimFrequency = (int)((Duration)this.bootstrap.props().APP_TIMER_INTERVAL.get()).getSeconds();
            ServerCacheOptions options = new ServerCacheOptions();
            options.setMaxSecsToLive(maxTtl);
            options.setMaxIdleSecs(maxIdle);
            options.setMaxSize(maxSize);
            options.setTrimFrequency(trimFrequency);
            ServerCacheConfig scc = new ServerCacheConfig(cacheType, cacheKey, shortName, options, tenantProvider, queryCacheValidate);
            if (config.isQueryCache()) {
                cache = new DefaultServerQueryCache(new DefaultServerCacheConfig(scc));
                ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                if (Objects.nonNull(prev)) {
                    cache = prev;
                } else {
                    this.logger.debug("created query cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
                }
            } else {
                boolean neverExpire = (Boolean)this.bootstrap.props().CACHE_LOCAL_NEVER_EXPIRE.get();
                if (neverExpire) {
                    cache = new LocalEbeanCache(cacheKey, maxSize, tenantProvider);
                    ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                    if (Objects.nonNull(prev)) {
                        cache = prev;
                    } else {
                        this.logger.debug("created local cache: {} with max size: {}", (Object)cacheKey, (Object)maxSize);
                    }
                } else {
                    cache = new LocalEbeanCache(cacheKey, new DefaultServerCacheConfig(scc), tenantProvider);
                    ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                    if (Objects.nonNull(prev)) {
                        cache = prev;
                    } else {
                        this.logger.debug("created local cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE));
                    }
                }
            }
            final ServerCache tmp = Objects.requireNonNull(cache);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (tmp instanceof LocalEbeanCache) {
                        ((LocalEbeanCache)tmp).get().cleanUp();
                    } else if (tmp instanceof DefaultServerQueryCache) {
                        ((DefaultServerQueryCache)tmp).runEviction();
                    }
                }
            }, (long)trimFrequency, (long)trimFrequency, TimeUnit.SECONDS);
        }
        return cache;
    }

    @Override
    public ServerCache getCache(String string) {
        return this.caches.get(string);
    }

    @Override
    public void clearAllLocal() {
        for (ServerCache cache : this.caches.values()) {
            if (cache instanceof SimpleCache || !(cache instanceof LocalEbeanCache)) continue;
            ((LocalEbeanCache)cache).onClear();
        }
    }

    @Override
    public void clearAllSimple() {
        for (ServerCache cache : this.caches.values()) {
            if (cache instanceof LocalEbeanCache || !(cache instanceof SimpleCache)) continue;
            ((SimpleCache)cache).onClear();
        }
    }

    @Override
    public void clearAll(boolean preserveSimple) {
        for (ServerCache cache : this.caches.values()) {
            if (cache instanceof SimpleCache) {
                if (!BooleanUtils.isFalse((Boolean)preserveSimple)) continue;
                ((SimpleCache)cache).onClear();
                continue;
            }
            if (!(cache instanceof LocalEbeanCache)) continue;
            ((LocalEbeanCache)cache).onClear();
        }
    }
}

