/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.collect.Sets;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ebean.Account;
import com.turbospaces.ebean.AccountBalance;
import com.turbospaces.ebean.AccountBalanceId;
import com.turbospaces.ebean.AccountBalanceSnapshot;
import com.turbospaces.ebean.AccountBalanceSnapshotId;
import com.turbospaces.ebean.AccountSeq;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.EbeanDatabaseConfig;
import com.turbospaces.ebean.EbeanFactoryBean;
import com.turbospaces.ebean.FraudJson;
import com.turbospaces.ebean.GameplayInfo;
import com.turbospaces.ebean.JGroupCacheManagerFactoryBean;
import com.turbospaces.ebean.JpaManager;
import com.turbospaces.ebean.TracedEbeanTransaction;
import com.turbospaces.ebean.UTMTemplate;
import com.turbospaces.ebean.query.QAccount;
import com.turbospaces.jdbc.HikariDataSourceFactoryBean;
import com.turbospaces.jgroups.JGroupsFactoryBean;
import com.turbospaces.plugins.FlywayBootstrapInitializer;
import com.turbospaces.ups.H2ServiceInfo;
import com.turbospaces.ups.UPSs;
import io.ebean.DuplicateKeyException;
import io.ebean.Transaction;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.awaitility.Awaitility;
import org.awaitility.core.ThrowingRunnable;
import org.jgroups.JChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.annotation.Bean;

public class EbeanInfinispanPluginTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Throwable {
        MockCloud builder = MockCloud.newMock();
        ApplicationConfig cfg = builder.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props, new Class[]{AppConfig.class});
        bootstrap.withH2(true, bootstrap.spaceName());
        H2ServiceInfo ownerUps = (H2ServiceInfo)UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)"h2-owner");
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new FlywayBootstrapInitializer((ServiceInfo)ownerUps, new String[]{"CORE"}));
        bootstrap.run(new String[0]);
        try {
            JpaManager ebean = (JpaManager)bootstrap.getBean(JpaManager.class);
            PlatformIdGenerator generator = ebean.idGenerator(AccountSeq.class);
            HashSet set = Sets.newHashSet();
            long now = System.currentTimeMillis();
            try (Transaction tx = ebean.beginTransaction();){
                for (int i = 0; i <= 16384; ++i) {
                    Account account = new Account();
                    long nextId = (Long)generator.nextId(tx);
                    Assertions.assertTrue((boolean)set.add(nextId));
                    account.setId(now + nextId);
                    account.setFraud(new FraudJson(Collections.emptyMap()));
                    account.setUsername("username_" + account.getId());
                    account.setFirstName("f_" + account.getId());
                    account.setLastName("l_" + account.getId());
                    account.setDetails(Collections.emptyMap());
                    ebean.save((Object)account, tx);
                }
                tx.commit();
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }

    @Configurable
    public static class AppConfig
    extends AbstractBootstrapAware {
        @Bean
        public HikariDataSourceFactoryBean ds() {
            ServiceInfo appUps = UPSs.findRequiredServiceInfoByName((Bootstrap)this.bootstrap, (String)"h2-app");
            return new HikariDataSourceFactoryBean(appUps);
        }

        @Bean
        public JGroupsFactoryBean jgroups() {
            return new JGroupsFactoryBean();
        }

        @Bean
        public JGroupCacheManagerFactoryBean cacheManager(JGroupsFactoryBean factory) throws Exception {
            return new JGroupCacheManagerFactoryBean((JChannel)factory.getObject());
        }

        @Bean
        public EbeanDatabaseConfig ebeanConfig(HikariDataSourceFactoryBean factory) throws Exception {
            EbeanDatabaseConfig cfg = new EbeanDatabaseConfig((DataSource)factory.getObject(), this.bootstrap.props());
            cfg.addClass(AccountSeq.class);
            cfg.addClass(Account.class);
            cfg.addClass(GameplayInfo.class);
            cfg.addClass(FraudJson.class);
            cfg.addClass(AccountBalance.class);
            cfg.addClass(AccountBalanceId.class);
            cfg.addClass(AccountBalanceSnapshot.class);
            cfg.addClass(AccountBalanceSnapshotId.class);
            cfg.addClass(UTMTemplate.class);
            cfg.setMaxSize(Account.class, 1);
            cfg.setMaxSizeQuery(Account.class, 1);
            cfg.setMaxSize(Account.class, QAccount.alias()._balances(), 1);
            cfg.setMaxSize(UTMTemplate.class, 8);
            cfg.setMaxSize(AccountBalance.class, 2);
            cfg.setMaxSize(AccountBalanceSnapshot.class, 4);
            cfg.setMaxSize(Account.class, QAccount.alias()._utmTemplates(), Integer.MAX_VALUE);
            return cfg;
        }

        @Bean
        public EbeanFactoryBean ebean(EbeanDatabaseConfig config, JGroupCacheManagerFactoryBean cache) throws Exception {
            return new EbeanFactoryBean(config, (CacheManager)cache.getObject());
        }

        @Bean
        public RollbackBean rollbackBean(EbeanFactoryBean ebean, CacheManager manager) throws Exception {
            return new RollbackBean((JpaManager)ebean.getObject(), manager);
        }

        @Bean
        public CacheBean cacheBean(EbeanFactoryBean ebean, CacheManager manager) throws Exception {
            return new CacheBean((JpaManager)ebean.getObject(), manager);
        }
    }

    public static class CacheBean
    extends AbstractBootstrapAware
    implements InitializingBean {
        private final JpaManager ebean;
        private final CacheManager manager;

        @Inject
        public CacheBean(JpaManager ebean, CacheManager manager) {
            this.ebean = ebean;
            this.manager = manager;
        }

        public void afterPropertiesSet() throws Exception {
            TracedEbeanTransaction tx;
            int i;
            Account account;
            String aname = Account.class.getName();
            String abname = AccountBalance.class.getName();
            long id = Math.abs(((Object)((Object)this)).hashCode());
            try (TracedEbeanTransaction tx2 = this.ebean.newTransaction("cache-bean-save");){
                account = new Account();
                account.setId(id);
                account.setFraud(new FraudJson(Collections.emptyMap()));
                account.setUsername("username_" + account.getId());
                account.setFirstName("f_" + account.getId());
                account.setLastName("l_" + account.getId());
                account.setDetails(Collections.emptyMap());
                AccountBalance balance1 = new AccountBalance(account, "USD");
                balance1.setAmount(BigDecimal.TEN);
                account.getBalances().add(balance1);
                AccountBalance balance2 = new AccountBalance(account, "EUR");
                balance2.setAmount(BigDecimal.ONE);
                account.getBalances().add(balance2);
                AccountBalance balance3 = new AccountBalance(account, "UAH");
                balance3.setAmount(BigDecimal.ONE);
                account.getBalances().add(balance3);
                this.ebean.save((Object)account);
                tx2.commit();
            }
            tx2 = this.ebean.newTransaction("cache-bean-save-all");
            try {
                for (Object it : this.ebean.find(Account.class).findList()) {
                    ((Account)it).setAge(((Account)it).getAge() + 1);
                    ((Account)it).setGameplayInfo(new GameplayInfo());
                    this.ebean.save(it, (Transaction)tx2);
                }
                tx2.commit();
            }
            finally {
                if (tx2 != null) {
                    tx2.close();
                }
            }
            for (i = 0; i < 10; ++i) {
                this.logger.debug("it ::: {}", (Object)i);
                tx = this.ebean.newReadOnlyTransaction("cache-bean-readonly");
                try {
                    tx.setReadOnly(true);
                    account = (Account)this.ebean.find(Account.class, (Object)id);
                    account.getBalances().size();
                    for (AccountBalance balance : account.getBalances()) {
                        balance.getAmount().toString();
                    }
                    continue;
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            for (i = 0; i < 10; ++i) {
                tx = this.ebean.newReadOnlyTransaction("cache-bean-readonly");
                try {
                    tx.setReadOnly(true);
                    Set accounts = this.ebean.createQuery(Account.class).setUseQueryCache(true).findSet();
                    accounts.size();
                    continue;
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            tx = this.ebean.newTransaction("cache-bean-save");
            try {
                account = (Account)this.ebean.find(Account.class, (Object)id);
                account.setAge(32);
                this.ebean.save((Object)account);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            Awaitility.await().atMost(Duration.ofSeconds(10L)).untilAsserted(new ThrowingRunnable(){

                public void run() throws Throwable {
                }
            });
            ServerCache aCache = this.manager.getCache(aname + ServerCacheType.BEAN.code());
            ServerCache bCache = this.manager.getCache(abname + ServerCacheType.BEAN.code());
            ServerCache cCache = this.manager.getCache(aname + "." + QAccount.alias()._balances().toString() + ServerCacheType.COLLECTION_IDS.code());
            Assertions.assertEquals((int)1, (int)aCache.size());
            Assertions.assertEquals((int)2, (int)bCache.size());
            Assertions.assertEquals((int)1, (int)cCache.size());
            this.ebean.cacheManager().beanCache(Account.class).clear();
            Assertions.assertEquals((int)0, (int)aCache.size());
            Assertions.assertEquals((int)2, (int)bCache.size());
            Assertions.assertEquals((int)1, (int)cCache.size());
            this.ebean.cacheManager().beanCache(AccountBalance.class).clear();
            Assertions.assertEquals((int)0, (int)bCache.size());
            this.ebean.cacheManager().clear(Account.class);
            Assertions.assertEquals((int)0, (int)cCache.size());
        }
    }

    private static class RollbackBean
    extends AbstractBootstrapAware
    implements InitializingBean {
        private final JpaManager ebean;
        private final CacheManager manager;

        @Inject
        public RollbackBean(JpaManager ebean, CacheManager manager) {
            this.ebean = ebean;
            this.manager = manager;
        }

        public void afterPropertiesSet() throws Exception {
            String tname = UTMTemplate.class.getName();
            long id = Math.abs(((Object)((Object)this)).hashCode());
            try (TracedEbeanTransaction tx = this.ebean.newTransaction("cache-bean-save");){
                Account account = new Account();
                account.setId(id);
                account.setFraud(new FraudJson(Collections.emptyMap()));
                account.setUsername("username_" + account.getId());
                account.setFirstName("f_" + account.getId());
                account.setLastName("l_" + account.getId());
                account.setDetails(Collections.emptyMap());
                this.ebean.save((Object)account);
                tx.flush();
                UTMTemplate template1 = new UTMTemplate(account, "utm-1");
                this.ebean.save((Object)template1, (Transaction)tx);
                UTMTemplate template2 = new UTMTemplate(account, "utm-2");
                this.ebean.save((Object)template2, (Transaction)tx);
                this.ebean.createQuery(UTMTemplate.class).usingTransaction((Transaction)tx).where().eq("account", (Object)account).eq("campaign", (Object)template1.getCampaign()).findOne();
                this.ebean.createQuery(UTMTemplate.class).usingTransaction((Transaction)tx).where().eq("account", (Object)account).eq("campaign", (Object)template2.getCampaign()).findOne();
                UTMTemplate template3 = new UTMTemplate(account, "utm-2");
                this.ebean.save((Object)template3, (Transaction)tx);
                tx.rollback();
            }
            catch (DuplicateKeyException err) {
                this.logger.warn(err.getMessage(), (Throwable)err);
            }
            ServerCache tCache = this.manager.getCache(tname + ServerCacheType.BEAN.code());
            Assertions.assertEquals((int)2, (int)tCache.size());
        }
    }
}

