package com.turbospaces.ebean;

import io.ebean.config.dbplatform.h2.H2Platform;
import io.ebeaninternal.api.SpiEbeanServer;

public class EbeanFactoryBean extends AbstractEbeanFactoryBean<JpaManager> {
    public EbeanFactoryBean(EbeanDatabaseConfig config, CacheManager cache) {
        super(config);
        config.setDatabasePlatform(new H2Platform());
        config.setServerCachePlugin(cache);
    }
    @Override
    public Class<?> getObjectType() {
        return JpaManager.class;
    }
    @Override
    protected JpaManager createEbean(SpiEbeanServer db) throws Exception {
        EbeanJpaManager jpaManager = new EbeanJpaManager(db, bootstrap.tracer());
        jpaManager.setTraceSeqUsage(true);
        return jpaManager;
    }
}
