package com.turbospaces.ebean;

import java.util.Objects;

import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;

public class JGroupCacheManagerFactoryBean extends AbstractFactoryBean<CacheManager> implements BootstrapAware {
    private final Logger log = LoggerFactory.getLogger(getClass());
    private final RpcDispatcher dispatcher = new RpcDispatcher();
    private final JChannel jchannel;
    private Bootstrap bootstrap;

    public JGroupCacheManagerFactoryBean(JChannel jchannel) {
        this.jchannel = Objects.requireNonNull(jchannel);
    }
    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }
    @Override
    public Class<?> getObjectType() {
        return CacheManager.class;
    }
    @Override
    protected CacheManager createInstance() throws Exception {
        JGroupsCacheManager manager = new JGroupsCacheManager(dispatcher, bootstrap.isDevMode() ? RequestOptions.SYNC() : RequestOptions.ASYNC());
        manager.setBootstrap(bootstrap);

        dispatcher.setChannel(jchannel);
        dispatcher.setServerObject(manager);
        dispatcher.setMethodLookup(manager);
        dispatcher.setMembershipListener(new MembershipListener() {
            @Override
            public void viewAccepted(View view) {
                log.debug("new view: {}", view);
            }
            @Override
            public void suspect(Address member) {
                log.debug("suspected member: {}", member);
            }
        });

        dispatcher.start();

        return manager;
    }
    @Override
    protected void destroyInstance(CacheManager instance) throws Exception {
        dispatcher.close();
    }
}
