/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.archaius.api.Config;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.LocalEbeanCache;
import com.turbospaces.ebean.ReplicatedCache;
import com.turbospaces.ebean.ReplicatedEbeanCache;
import com.turbospaces.ebean.SimpleCache;
import io.ebean.BackgroundExecutor;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.cache.ServerCacheType;
import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.GuavaCacheMetrics;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;

public class JGroupsCacheManager
extends AbstractBootstrapAware
implements MethodLookup,
CacheManager,
ServerCacheFactory,
ServerCacheNotify {
    public static short METHOD_ON_CACHE_PUT = 1;
    public static short METHOD_ON_CHANGE_REMOVE = (short)2;
    public static short METHOD_ON_CACHE_CLEAR = (short)3;
    public static short METHOD_ON_MODIFIED = (short)4;
    public static short METHOD_ON_CACHE_CLEAR_ALL = (short)5;
    public static ImmutableMap<Short, Method> METHODS;
    private final RpcDispatcher dispatcher;
    private final RequestOptions requestOptions;
    private final ConcurrentMap<String, ServerCache> caches;
    private BackgroundExecutor executor;
    private ServerCacheNotify notify;

    public JGroupsCacheManager(RpcDispatcher dispatcher, RequestOptions requestOptions) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.requestOptions = Objects.requireNonNull(requestOptions);
        this.caches = Maps.newConcurrentMap();
    }

    public Method findMethod(short id) {
        return (Method)METHODS.get((Object)id);
    }

    public ServerCacheFactory create(DatabaseConfig config, BackgroundExecutor backgroundExecutor) {
        this.executor = Objects.requireNonNull(backgroundExecutor);
        return this;
    }

    public ServerCacheNotify createCacheNotify(ServerCacheNotify cacheNotify) {
        this.notify = Objects.requireNonNull(cacheNotify);
        return this;
    }

    public void notify(ServerCacheNotification notification) {
        if (notification.getDependentTables() != null && !notification.getDependentTables().isEmpty()) {
            Set dependentTables = notification.getDependentTables();
            String line = Joiner.on((char)',').join((Iterable)dependentTables);
            this.logger.debug("Publish TableMods - {}", (Object)line);
            try {
                MethodCall call = new MethodCall(METHOD_ON_MODIFIED, new Object[]{line});
                RspList l = this.dispatcher.callRemoteMethods(null, call, this.requestOptions);
                if (Objects.nonNull(l)) {
                    ReplicatedCache.trace(this.logger, (RspList<Object>)l);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    @Override
    public void onTablesModify(String line) {
        Iterable it = Splitter.on((char)',').omitEmptyStrings().split((CharSequence)line);
        ImmutableSet tables = ImmutableSet.copyOf((Iterable)it);
        ServerCacheNotification notification = new ServerCacheNotification((Set)tables);
        this.notify.notify(notification);
    }

    @Override
    public void onCachePut(String cacheKey, byte[] id, byte[] value) {
        ReplicatedEbeanCache cache = (ReplicatedEbeanCache)this.caches.get(cacheKey);
        if (cache != null) {
            cache.onPut(id, value);
        }
    }

    @Override
    public void onCacheRemove(String cacheKey, byte[] id) {
        ReplicatedEbeanCache cache = (ReplicatedEbeanCache)this.caches.get(cacheKey);
        if (cache != null) {
            cache.onRemove(id);
        }
    }

    @Override
    public void onCacheClear(String cacheKey) {
        ServerCache cache = (ServerCache)this.caches.get(cacheKey);
        if (cache != null && cache instanceof ReplicatedEbeanCache) {
            ((ReplicatedEbeanCache)cache).onClear();
        }
    }

    @Override
    public void onCacheClearAll(boolean preserveSimple) {
        for (ServerCache cache : this.caches.values()) {
            if (cache instanceof ReplicatedEbeanCache) {
                ((ReplicatedEbeanCache)cache).onClear();
                continue;
            }
            if (cache instanceof SimpleCache) {
                if (!BooleanUtils.isFalse((Boolean)preserveSimple)) continue;
                ((SimpleCache)cache).onClear();
                continue;
            }
            if (!(cache instanceof LocalEbeanCache)) continue;
            ((LocalEbeanCache)cache).onClear();
        }
    }

    @Override
    public ServerCache getCache(String cacheKey) {
        return (ServerCache)this.caches.get(cacheKey);
    }

    @Override
    public void clearAllLocal() {
        for (ServerCache cache : this.caches.values()) {
            if (cache instanceof ReplicatedEbeanCache || cache instanceof SimpleCache || !(cache instanceof LocalEbeanCache)) continue;
            ((LocalEbeanCache)cache).onClear();
        }
    }

    @Override
    public void clearAllSimple() {
        for (ServerCache cache : this.caches.values()) {
            if (cache instanceof ReplicatedEbeanCache || cache instanceof LocalEbeanCache || !(cache instanceof SimpleCache)) continue;
            ((SimpleCache)cache).onClear();
        }
    }

    @Override
    public void clearAll(boolean preserveSimple) {
        try {
            MethodCall call = new MethodCall(METHOD_ON_CACHE_CLEAR_ALL, new Object[]{preserveSimple});
            RspList l = this.dispatcher.callRemoteMethods(null, call, this.requestOptions);
            if (Objects.nonNull(l)) {
                ReplicatedCache.trace(this.logger, (RspList<Object>)l);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.onCacheClearAll(preserveSimple);
        }
    }

    @Override
    public SimpleCache createSimpleCache(String name) {
        ServerCache cache = (ServerCache)this.caches.get(name);
        if (Objects.isNull(cache)) {
            cache = new SimpleCache(name);
            ServerCache prev = this.caches.putIfAbsent(name, cache);
            if (Objects.nonNull(prev)) {
                cache = prev;
            } else {
                new GuavaCacheMetrics(((SimpleCache)cache).get(), name, Collections.emptyList()).bindTo(this.bootstrap.meterRegistry());
            }
        }
        return (SimpleCache)cache;
    }

    public ServerCache createCache(ServerCacheConfig config) {
        String cacheKey = config.getCacheKey();
        String shortName = config.getShortName();
        ServerCacheOptions cacheOptions = config.getCacheOptions();
        ServerCacheType cacheType = config.getType();
        CurrentTenantProvider tenantProvider = config.getTenantProvider();
        QueryCacheEntryValidate queryCacheValidate = config.getQueryCacheEntryValidate();
        ServerCache cache = (ServerCache)this.caches.get(cacheKey);
        if (Objects.isNull(cache)) {
            Config prefixedView = this.bootstrap.cfg().getPrefixedView(cacheKey);
            Iterator it = prefixedView.getKeys();
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object rawProperty = prefixedView.getRawProperty(key);
                configMap.put(key, rawProperty);
            }
            int maxTtl = prefixedView.getInteger("max-ttl", Integer.valueOf(cacheOptions.getMaxSecsToLive()));
            int maxIdle = prefixedView.getInteger("max-idle", Integer.valueOf(cacheOptions.getMaxIdleSecs()));
            int maxSize = prefixedView.getInteger("max-size", Integer.valueOf(cacheOptions.getMaxSize()));
            int trimFrequency = (int)((Duration)this.bootstrap.props().APP_TIMER_INTERVAL.get()).getSeconds();
            ServerCacheOptions options = new ServerCacheOptions();
            options.setMaxSecsToLive(maxTtl);
            options.setMaxIdleSecs(maxIdle);
            options.setMaxSize(maxSize);
            options.setTrimFrequency(trimFrequency);
            ServerCacheConfig scc = new ServerCacheConfig(cacheType, cacheKey, shortName, options, tenantProvider, queryCacheValidate);
            ArrayList tags = Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"cacheType", (String)cacheType.name().toLowerCase()), Tag.of((String)"shortName", (String)shortName)});
            if (config.isQueryCache()) {
                cache = new DefaultServerQueryCache(new DefaultServerCacheConfig(scc));
                ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                if (Objects.nonNull(prev)) {
                    cache = prev;
                } else {
                    this.logger.debug("created query cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
                }
            } else {
                boolean localMode = prefixedView.getBoolean("cache-mode-local", Boolean.valueOf(true));
                if (localMode) {
                    boolean neverExpire = (Boolean)this.bootstrap.props().CACHE_LOCAL_NEVER_EXPIRE.get();
                    if (neverExpire) {
                        cache = new LocalEbeanCache(cacheKey, maxSize, tenantProvider);
                        ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                        if (Objects.nonNull(prev)) {
                            cache = prev;
                        } else {
                            new GuavaCacheMetrics(((LocalEbeanCache)cache).get(), cacheKey, (Iterable)tags).bindTo(this.bootstrap.meterRegistry());
                            this.logger.debug("created local cache: {} with max size: {}", (Object)cacheKey, (Object)maxSize);
                        }
                    } else {
                        cache = new LocalEbeanCache(cacheKey, new DefaultServerCacheConfig(scc), tenantProvider);
                        ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                        if (Objects.nonNull(prev)) {
                            cache = prev;
                        } else {
                            new GuavaCacheMetrics(((LocalEbeanCache)cache).get(), cacheKey, (Iterable)tags).bindTo(this.bootstrap.meterRegistry());
                            this.logger.debug("created local cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE));
                        }
                    }
                } else {
                    boolean neverExpire = (Boolean)this.bootstrap.props().CACHE_REPLICATED_NEVER_EXPIRE.get();
                    if (neverExpire) {
                        LocalEbeanCache local = new LocalEbeanCache(cacheKey, maxSize, tenantProvider);
                        cache = new ReplicatedEbeanCache(cacheKey, this.dispatcher, this.requestOptions, local, scc);
                        ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                        if (Objects.nonNull(prev)) {
                            cache = prev;
                        } else {
                            new GuavaCacheMetrics(local.get(), cacheKey, (Iterable)tags).bindTo(this.bootstrap.meterRegistry());
                            this.logger.debug("created replicated cache: {} with max size: {}", (Object)cacheKey, (Object)maxSize);
                        }
                    } else {
                        LocalEbeanCache local = new LocalEbeanCache(cacheKey, new DefaultServerCacheConfig(scc), tenantProvider);
                        cache = new ReplicatedEbeanCache(cacheKey, this.dispatcher, this.requestOptions, local, scc);
                        ServerCache prev = this.caches.putIfAbsent(cacheKey, cache);
                        if (Objects.nonNull(prev)) {
                            cache = prev;
                        } else {
                            new GuavaCacheMetrics(local.get(), cacheKey, (Iterable)tags).bindTo(this.bootstrap.meterRegistry());
                            this.logger.debug("created replicated cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE));
                        }
                    }
                }
            }
            final ServerCache tmp = Objects.requireNonNull(cache);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (tmp instanceof LocalEbeanCache) {
                        ((LocalEbeanCache)tmp).get().cleanUp();
                    } else if (tmp instanceof DefaultServerQueryCache) {
                        ((DefaultServerQueryCache)tmp).runEviction();
                    }
                }
            }, (long)trimFrequency, (long)trimFrequency, TimeUnit.SECONDS);
        }
        return cache;
    }

    static {
        try {
            ImmutableMap.Builder b = ImmutableMap.builder();
            b.put((Object)METHOD_ON_MODIFIED, (Object)JGroupsCacheManager.class.getMethod("onTablesModify", String.class));
            b.put((Object)METHOD_ON_CACHE_PUT, (Object)JGroupsCacheManager.class.getMethod("onCachePut", String.class, byte[].class, byte[].class));
            b.put((Object)METHOD_ON_CHANGE_REMOVE, (Object)JGroupsCacheManager.class.getMethod("onCacheRemove", String.class, byte[].class));
            b.put((Object)METHOD_ON_CACHE_CLEAR, (Object)JGroupsCacheManager.class.getMethod("onCacheClear", String.class));
            b.put((Object)METHOD_ON_CACHE_CLEAR_ALL, (Object)JGroupsCacheManager.class.getMethod("onCacheClearAll", Boolean.TYPE));
            METHODS = b.build();
        }
        catch (NoSuchMethodException err) {
            throw new Error(err);
        }
    }
}

