package com.turbospaces.ebean;

import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;

import io.ebean.typequery.TQAssocBean;

public interface EbeanCacheConfigurer {
    String MAX_SIZE = "max-size";
    String MAX_TTL = "max-ttl";
    String MAX_IDLE = "max-idle";
    String CACHE_MODE_LOCAL = "cache-mode-local";

    ApplicationConfig cfg();
    ApplicationProperties props();

    void setMaxIdle(Class<?> clazz, int value);
    void setMaxTTL(Class<?> clazz, int value);
    void setMaxSize(Class<?> clazz, int value);
    void setCacheMode(Class<?> clazz, boolean local);
    default void setMaxSizeAndMode(Class<?> clazz, int value, boolean local) {
        setMaxSize(clazz, value);
        setCacheMode(clazz, local);
    }
    default void setMaxSizeReplicated(Class<?> clazz, int value) {
        setMaxSizeAndMode(clazz, value, false);
    }
    default void setMaxSizeLocal(Class<?> clazz, int value) {
        setMaxSizeAndMode(clazz, value, true);
    }

    void setMaxSizeQuery(Class<?> clazz, int value);

    void setMaxIdle(Class<?> clazz, TQAssocBean<?, ?> assoc, int value);
    void setMaxTTL(Class<?> clazz, TQAssocBean<?, ?> assoc, int value);
    void setMaxSize(Class<?> clazz, TQAssocBean<?, ?> assoc, int value);
    void setCacheMode(Class<?> clazz, TQAssocBean<?, ?> assoc, boolean local);
    default void setMaxSizeAndMode(Class<?> clazz, TQAssocBean<?, ?> assoc, int value, boolean local) {
        setMaxSize(clazz, assoc, value);
        setCacheMode(clazz, assoc, local);
    }
    default void setMaxSizeReplicated(Class<?> clazz, TQAssocBean<?, ?> assoc, int value) {
        setMaxSizeAndMode(clazz, assoc, value, false);
    }
    default void setMaxSizeLocal(Class<?> clazz, TQAssocBean<?, ?> assoc, int value) {
        setMaxSizeAndMode(clazz, assoc, value, true);
    }
}
