/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.netflix.archaius.api.Config;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.LocalEbeanCache;
import com.turbospaces.ebean.ReplicatedEbeanCache;
import com.turbospaces.ebean.SimpleCache;
import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.cache.ServerCacheOptions;
import io.ebean.cache.ServerCacheType;
import io.ebean.config.CurrentTenantProvider;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.GuavaCacheMetrics;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;

public class DefaultEbeanCacheManager
extends AbstractBootstrapAware
implements ServerCacheNotify,
CacheManager {
    public static ImmutableMap<Short, Method> METHODS;
    private final Map<String, ServerCache> caches = new ConcurrentHashMap<String, ServerCache>();
    private final RpcDispatcher dispatcher;
    private final RequestOptions requestOptions;
    private ServerCacheNotify notify;

    public DefaultEbeanCacheManager(RpcDispatcher dispatcher, RequestOptions requestOptions) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.requestOptions = Objects.requireNonNull(requestOptions);
    }

    public Method findMethod(short id) {
        return (Method)METHODS.get((Object)id);
    }

    @Override
    public ServerCache cache(String cacheKey) {
        return this.caches.get(cacheKey);
    }

    public ServerCache createCache(ServerCacheConfig config) {
        return this.getCache(config);
    }

    public ServerCacheNotify createCacheNotify(ServerCacheNotify cacheNotify) {
        this.notify = Objects.requireNonNull(cacheNotify);
        return this;
    }

    public void notify(ServerCacheNotification notification) {
        if (notification.getDependentTables() != null && !notification.getDependentTables().isEmpty()) {
            Set dependentTables = notification.getDependentTables();
            String line = Joiner.on((char)',').join((Iterable)dependentTables);
            this.logger.debug("Publish TableMods - {}", (Object)line);
            try {
                MethodCall call = new MethodCall(4, new Object[]{line});
                RspList l = this.dispatcher.callRemoteMethods(null, call, this.requestOptions);
                if (l != null) {
                    CacheManager.trace(this.logger, (RspList<Object>)l);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    @Override
    public void onTablesModify(String line) {
        Iterable it = Splitter.on((char)',').omitEmptyStrings().split((CharSequence)line);
        ImmutableSet tables = ImmutableSet.copyOf((Iterable)it);
        ServerCacheNotification notification = new ServerCacheNotification((Set)tables);
        this.notify.notify(notification);
    }

    @Override
    public void onCachePut(String cacheKey, byte[] id, byte[] value) {
        ReplicatedEbeanCache cache = (ReplicatedEbeanCache)this.caches.get(cacheKey);
        if (cache != null) {
            cache.onPut(id, value);
        }
    }

    @Override
    public void onCacheRemove(String cacheKey, byte[] id) {
        ReplicatedEbeanCache cache = (ReplicatedEbeanCache)this.caches.get(cacheKey);
        if (cache != null) {
            cache.onRemove(id);
        }
    }

    @Override
    public void onCacheClear(String cacheKey) {
        ServerCache cache = this.caches.get(cacheKey);
        if (cache != null && cache instanceof ReplicatedEbeanCache) {
            ((ReplicatedEbeanCache)cache).onClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCacheClearAll(boolean preserveSimple) {
        DefaultEbeanCacheManager defaultEbeanCacheManager = this;
        synchronized (defaultEbeanCacheManager) {
            for (ServerCache cache : this.caches.values()) {
                if (cache instanceof ReplicatedEbeanCache) {
                    ((ReplicatedEbeanCache)cache).onClear();
                    continue;
                }
                if (cache instanceof SimpleCache) {
                    if (preserveSimple) continue;
                    ((SimpleCache)cache).onClear();
                    continue;
                }
                if (!(cache instanceof LocalEbeanCache)) continue;
                ((LocalEbeanCache)cache).onClear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleCache simpleCache(String name) {
        DefaultEbeanCacheManager defaultEbeanCacheManager = this;
        synchronized (defaultEbeanCacheManager) {
            ServerCache cache = this.caches.get(name);
            if (cache == null) {
                cache = new SimpleCache(name);
                this.caches.put(name, cache);
            }
            return (SimpleCache)cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllLocal() {
        DefaultEbeanCacheManager defaultEbeanCacheManager = this;
        synchronized (defaultEbeanCacheManager) {
            for (ServerCache cache : this.caches.values()) {
                if (cache instanceof ReplicatedEbeanCache || cache instanceof SimpleCache || !(cache instanceof LocalEbeanCache)) continue;
                ((LocalEbeanCache)cache).onClear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllSimple() {
        DefaultEbeanCacheManager defaultEbeanCacheManager = this;
        synchronized (defaultEbeanCacheManager) {
            for (ServerCache cache : this.caches.values()) {
                if (cache instanceof ReplicatedEbeanCache || cache instanceof LocalEbeanCache || !(cache instanceof SimpleCache)) continue;
                ((SimpleCache)cache).onClear();
            }
        }
    }

    @Override
    public void clearAll(boolean preserveSimple) {
        try {
            MethodCall call = new MethodCall(5, new Object[]{preserveSimple});
            RspList l = this.dispatcher.callRemoteMethods(null, call, this.requestOptions);
            if (l != null) {
                CacheManager.trace(this.logger, (RspList<Object>)l);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.onCacheClearAll(preserveSimple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerCache getCache(ServerCacheConfig config) {
        String cacheKey = config.getCacheKey();
        String shortName = config.getShortName();
        ServerCacheOptions cacheOptions = config.getCacheOptions();
        ServerCacheType cacheType = config.getType();
        CurrentTenantProvider tenantProvider = config.getTenantProvider();
        QueryCacheEntryValidate queryCacheValidate = config.getQueryCacheEntryValidate();
        DefaultEbeanCacheManager defaultEbeanCacheManager = this;
        synchronized (defaultEbeanCacheManager) {
            ServerCache cache = this.caches.get(cacheKey);
            if (cache == null) {
                Config prefixedView = this.bootstrap.cfg().getPrefixedView(cacheKey);
                Iterator it = prefixedView.getKeys();
                HashMap<String, Object> configMap = new HashMap<String, Object>();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object rawProperty = prefixedView.getRawProperty(key);
                    configMap.put(key, rawProperty);
                }
                int maxTtl = prefixedView.getInteger("max-ttl", Integer.valueOf(cacheOptions.getMaxSecsToLive()));
                int maxIdle = prefixedView.getInteger("max-idle", Integer.valueOf(cacheOptions.getMaxIdleSecs()));
                int maxSize = prefixedView.getInteger("max-size", Integer.valueOf(cacheOptions.getMaxSize()));
                int trimFrequency = (int)((Duration)this.bootstrap.props().APP_TIMER_INTERVAL.get()).toSeconds();
                ServerCacheOptions options = new ServerCacheOptions();
                options.setMaxSecsToLive(maxTtl);
                options.setMaxIdleSecs(maxIdle);
                options.setMaxSize(maxSize);
                options.setTrimFrequency(trimFrequency);
                ServerCacheConfig scc = new ServerCacheConfig(cacheType, cacheKey, shortName, options, tenantProvider, queryCacheValidate);
                List<Tag> tags = List.of(Tag.of((String)"cacheType", (String)cacheType.name().toLowerCase()), Tag.of((String)"shortName", (String)shortName));
                if (config.isQueryCache()) {
                    this.logger.debug("creating query cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
                    cache = new DefaultServerQueryCache(new DefaultServerCacheConfig(scc));
                } else {
                    boolean localMode = prefixedView.getBoolean("cache-mode-local", Boolean.valueOf(true));
                    if (localMode) {
                        boolean neverExpire = (Boolean)this.bootstrap.props().CACHE_LOCAL_NEVER_EXPIRE.get();
                        if (neverExpire) {
                            this.logger.debug("creating local cache: {} with max size: {}", (Object)cacheKey, (Object)maxSize);
                            cache = new LocalEbeanCache(cacheKey, maxSize, tenantProvider);
                        } else {
                            this.logger.debug("creating local cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE));
                            cache = new LocalEbeanCache(cacheKey, new DefaultServerCacheConfig(scc), tenantProvider);
                        }
                        new GuavaCacheMetrics(((LocalEbeanCache)cache).get(), cacheKey, tags).bindTo(this.bootstrap.meterRegistry());
                    } else {
                        LocalEbeanCache local;
                        boolean neverExpire = (Boolean)this.bootstrap.props().CACHE_REPLICATED_NEVER_EXPIRE.get();
                        if (neverExpire) {
                            this.logger.debug("creating replicated cache: {} with max size: {}", (Object)cacheKey, (Object)maxSize);
                            local = new LocalEbeanCache(cacheKey, maxSize, tenantProvider);
                        } else {
                            this.logger.debug("creating replicated cache: {} using cfg {}", (Object)cacheKey, (Object)ToStringBuilder.reflectionToString((Object)options, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE));
                            local = new LocalEbeanCache(cacheKey, new DefaultServerCacheConfig(scc), tenantProvider);
                        }
                        new GuavaCacheMetrics(local.get(), cacheKey, tags).bindTo(this.bootstrap.meterRegistry());
                        cache = new ReplicatedEbeanCache(cacheKey, this.dispatcher, this.requestOptions, local, scc);
                    }
                }
                this.caches.put(cacheKey, cache);
                final ServerCache tmp = cache;
                this.bootstrap.globalPlatform().scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        if (tmp instanceof LocalEbeanCache) {
                            ((LocalEbeanCache)tmp).get().cleanUp();
                        } else if (tmp instanceof DefaultServerQueryCache) {
                            ((DefaultServerQueryCache)tmp).runEviction();
                        }
                    }
                }, (long)trimFrequency, (long)trimFrequency, TimeUnit.SECONDS);
            }
            return cache;
        }
    }

    static {
        try {
            ImmutableMap.Builder b = ImmutableMap.builder();
            b.put((Object)4, (Object)DefaultEbeanCacheManager.class.getMethod("onTablesModify", String.class));
            b.put((Object)1, (Object)DefaultEbeanCacheManager.class.getMethod("onCachePut", String.class, byte[].class, byte[].class));
            b.put((Object)2, (Object)DefaultEbeanCacheManager.class.getMethod("onCacheRemove", String.class, byte[].class));
            b.put((Object)3, (Object)DefaultEbeanCacheManager.class.getMethod("onCacheClear", String.class));
            b.put((Object)5, (Object)DefaultEbeanCacheManager.class.getMethod("onCacheClearAll", Boolean.TYPE));
            METHODS = b.build();
        }
        catch (NoSuchMethodException err) {
            throw new Error(err);
        }
    }
}

