/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ebean.Account;
import com.turbospaces.ebean.AccountBalance;
import com.turbospaces.ebean.AccountBalanceId;
import com.turbospaces.ebean.AccountBalanceSnapshot;
import com.turbospaces.ebean.AccountBalanceSnapshotId;
import com.turbospaces.ebean.CacheBootstrapInitializer;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.DefaultEbeanCacheConfigurer;
import com.turbospaces.ebean.EbeanFactoryBean;
import com.turbospaces.ebean.FraudJson;
import com.turbospaces.ebean.GameplayInfo;
import com.turbospaces.ebean.UTMTemplate;
import com.turbospaces.ebean.query.QAccount;
import com.turbospaces.ebean.query.QAccountBalance;
import com.turbospaces.jdbc.HikariDataSourceFactoryBean;
import com.turbospaces.plugins.FlywayBootstrapInitializer;
import com.turbospaces.plugins.JGroupsBootstrapInitializer;
import com.turbospaces.ups.UPSs;
import io.ebean.BackgroundExecutor;
import io.ebean.Database;
import io.ebean.ProfileLocation;
import io.ebean.bean.EnhancedTransactional;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCachePlugin;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.h2.H2Platform;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.sql.DataSource;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.annotation.Bean;

public class CompositeKeyTest
implements EnhancedTransactional {
    private static /* synthetic */ ProfileLocation _$ebpq0;

    @Test
    public void works() throws Throwable {
        MockCloud builder = MockCloud.newMock();
        builder.withH2(true);
        ApplicationConfig cfg = builder.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        DefaultEbeanCacheConfigurer mngr = new DefaultEbeanCacheConfigurer(props);
        mngr.setMaxSizeLocal(Account.class, 1);
        mngr.setMaxSizeQuery(Account.class, 1);
        mngr.setMaxSizeLocal(Account.class, QAccount.alias()._balances(), 1);
        mngr.setMaxSizeReplicated(UTMTemplate.class, 8);
        mngr.setMaxSizeReplicated(AccountBalance.class, 10);
        mngr.setMaxSizeReplicated(AccountBalance.class, QAccountBalance.alias()._snapshots(), 10);
        mngr.setMaxSizeReplicated(AccountBalanceSnapshot.class, 30);
        mngr.setMaxSizeReplicated(Account.class, QAccount.alias()._utmTemplates(), Integer.MAX_VALUE);
        SimpleBootstrap bootstrap = new SimpleBootstrap(AppConfig.class, new ApplicationProperties(cfg));
        ServiceInfo ownerUps = UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)"h2-owner");
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new FlywayBootstrapInitializer(ownerUps, new String[]{"CORE"}));
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new JGroupsBootstrapInitializer(false));
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new CacheBootstrapInitializer());
        bootstrap.run(new String[0]);
        Database ebean = (Database)bootstrap.context().getBean(Database.class);
        Account account = new Account();
        account.setId(System.currentTimeMillis());
        account.setUsername("username_" + account.getId());
        account.setFirstName("f_" + account.getId());
        account.setLastName("l_" + account.getId());
        account.setAge(18);
        account.setBirthDate(LocalDate.now().minusYears(account.getAge()));
        ebean.save((Object)account);
        AccountBalance balance = new AccountBalance(account, "USD");
        balance.setAmount(BigDecimal.ONE);
        AccountBalanceSnapshot snapshot1 = new AccountBalanceSnapshot(balance, LocalDate.now());
        AccountBalanceSnapshot snapshot2 = new AccountBalanceSnapshot(balance, LocalDate.now().plusDays(1L));
        balance.getSnapshots().add(snapshot1);
        balance.getSnapshots().add(snapshot2);
        ebean.save((Object)balance);
        QAccountBalance q = (QAccountBalance)((Object)new QAccountBalance(ebean).setProfileLocation(_$ebpq0));
        q.setId(balance.getPk());
        q.findList();
        bootstrap.shutdown();
    }

    static {
        CompositeKeyTest._$ebpq0 = ProfileLocation.create();
    }

    @Configurable
    public static class AppConfig {
        @Bean
        public HikariDataSourceFactoryBean ds(Cloud cloud) {
            ServiceInfo appUps = UPSs.findRequiredServiceInfoByName((Cloud)cloud, (String)"h2-app");
            return new HikariDataSourceFactoryBean(appUps);
        }

        @Bean
        public EbeanFactoryBean ebean(HikariDataSourceFactoryBean ds, final CacheManager cache) throws Exception {
            return new EbeanFactoryBean((DataSource)ds.getObject()){

                protected void configure(DatabaseConfig config) {
                    config.setDatabasePlatform((DatabasePlatform)new H2Platform());
                    config.setServerCachePlugin(new ServerCachePlugin(){

                        public ServerCacheFactory create(DatabaseConfig dc, BackgroundExecutor executor) {
                            return cache;
                        }
                    });
                    config.addClass(Account.class);
                    config.addClass(GameplayInfo.class);
                    config.addClass(FraudJson.class);
                    config.addClass(UTMTemplate.class);
                    config.addClass(AccountBalance.class);
                    config.addClass(AccountBalanceId.class);
                    config.addClass(AccountBalanceSnapshot.class);
                    config.addClass(AccountBalanceSnapshotId.class);
                }
            };
        }
    }
}

