package com.turbospaces.ebean;

import java.util.Map.Entry;

import org.jgroups.Address;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.slf4j.Logger;

import com.turbospaces.boot.BootstrapAware;

import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheFactory;

public interface CacheManager extends MethodLookup, ServerCacheFactory, BootstrapAware {
    short METHOD_ON_CACHE_PUT = 1;
    short METHOD_ON_CHANGE_REMOVE = 2;
    short METHOD_ON_CACHE_CLEAR = 3;
    short METHOD_ON_MODIFIED = 4;
    short METHOD_ON_CACHE_CLEAR_ALL = 5;

    SimpleCache simpleCache(String name);
    ServerCache cache(String cacheKey);

    void clearAllLocal();
    void clearAllSimple();
    void clearAll(boolean preserveSimple);

    void onCachePut(String cacheKey, byte[] id, byte[] value);
    void onCacheRemove(String cacheKey, byte[] id);
    void onCacheClear(String cacheKey);
    void onCacheClearAll(boolean preserveSimple);
    void onTablesModify(String tables);

    static void trace(Logger logger, RspList<Object> l) {
        for (Entry<Address, Rsp<Object>> it : l.entrySet()) {
            Address address = it.getKey();
            Rsp<Object> rsp = it.getValue();
            if (rsp.hasException()) {
                logger.error("{} : {}", address, rsp);
            } else {
                logger.trace("{} : {}", address, rsp);
            }
        }
    }
}
