/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ebean.AbstractEbeanAwareService;
import com.turbospaces.ebean.Account;
import com.turbospaces.ebean.AccountBalance;
import com.turbospaces.ebean.AccountBalanceId;
import com.turbospaces.ebean.AccountBalanceSnapshot;
import com.turbospaces.ebean.AccountBalanceSnapshotId;
import com.turbospaces.ebean.CacheBootstrapInitializer;
import com.turbospaces.ebean.CacheCleanTask;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.DefaultEbeanCacheConfigurer;
import com.turbospaces.ebean.EbeanFactoryBean;
import com.turbospaces.ebean.FraudJson;
import com.turbospaces.ebean.GameplayInfo;
import com.turbospaces.ebean.UTMTemplate;
import com.turbospaces.ebean.query.QAccount;
import com.turbospaces.jdbc.HikariDataSourceFactoryBean;
import com.turbospaces.plugins.FlywayBootstrapInitializer;
import com.turbospaces.plugins.JGroupsBootstrapInitializer;
import com.turbospaces.ups.UPSs;
import io.ebean.BackgroundExecutor;
import io.ebean.Database;
import io.ebean.DuplicateKeyException;
import io.ebean.Transaction;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCachePlugin;
import io.ebean.cache.ServerCacheType;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.h2.H2Platform;
import io.ebean.typequery.TQAssocBean;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.awaitility.Awaitility;
import org.awaitility.core.ThrowingRunnable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.service.common.RelationalServiceInfo;
import org.springframework.context.annotation.Bean;

public class EbeanInfinispanPluginTest {
    @Bean
    public HikariDataSourceFactoryBean ds(Cloud cloud) {
        RelationalServiceInfo appUps = (RelationalServiceInfo)UPSs.findRequiredServiceInfoByName((Cloud)cloud, (String)"h2-app");
        return new HikariDataSourceFactoryBean(appUps);
    }

    @Bean
    public EbeanFactoryBean ebean(DataSource ds, final CacheManager cache) {
        return new EbeanFactoryBean(ds){

            protected void configure(DatabaseConfig config) {
                config.setDatabasePlatform((DatabasePlatform)new H2Platform());
                config.setServerCachePlugin(new ServerCachePlugin(){

                    public ServerCacheFactory create(DatabaseConfig dc, BackgroundExecutor executor) {
                        return cache;
                    }
                });
                config.addClass(Account.class);
                config.addClass(GameplayInfo.class);
                config.addClass(FraudJson.class);
                config.addClass(AccountBalance.class);
                config.addClass(AccountBalanceId.class);
                config.addClass(AccountBalanceSnapshot.class);
                config.addClass(AccountBalanceSnapshotId.class);
                config.addClass(UTMTemplate.class);
            }
        };
    }

    public CacheBean cacheBean(EbeanFactoryBean ebean, CacheManager manager) throws Exception {
        return new CacheBean((Database)ebean.getObject(), manager);
    }

    public CacheCleanBean cacheCleanBean(EbeanFactoryBean ebean, CacheManager manager) throws Exception {
        return new CacheCleanBean((Database)ebean.getObject(), manager);
    }

    @Bean
    public RollbackBean rollbackBean(EbeanFactoryBean ebean, CacheManager manager) throws Exception {
        return new RollbackBean((Database)ebean.getObject(), manager);
    }

    @Test
    public void works() throws Throwable {
        MockCloud builder = MockCloud.newMock();
        builder.withH2(true);
        ApplicationConfig cfg = builder.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        DefaultEbeanCacheConfigurer mngr = new DefaultEbeanCacheConfigurer(props);
        mngr.setMaxSizeLocal(Account.class, 1);
        mngr.setMaxSizeQuery(Account.class, 1);
        mngr.setMaxSizeLocal(Account.class, QAccount.alias()._balances(), 1);
        mngr.setMaxSizeReplicated(UTMTemplate.class, 8);
        mngr.setMaxSizeReplicated(AccountBalance.class, 2);
        mngr.setMaxSizeReplicated(AccountBalanceSnapshot.class, 4);
        mngr.setMaxSizeReplicated(Account.class, QAccount.alias()._utmTemplates(), Integer.MAX_VALUE);
        SimpleBootstrap bootstrap = new SimpleBootstrap(EbeanInfinispanPluginTest.class, new ApplicationProperties(cfg));
        RelationalServiceInfo ownerUps = (RelationalServiceInfo)UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)"h2-owner");
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new JGroupsBootstrapInitializer(false));
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new FlywayBootstrapInitializer(ownerUps, new String[]{"CORE"}));
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new CacheBootstrapInitializer());
        bootstrap.run(new String[0]);
        bootstrap.shutdown();
    }

    private static class CacheBean
    extends AbstractEbeanAwareService
    implements InitializingBean {
        private final CacheManager manager;

        @Inject
        public CacheBean(Database ebean, CacheManager manager) {
            super(ebean);
            this.manager = manager;
        }

        public void afterPropertiesSet() throws Exception {
            Transaction tx;
            int i;
            Account account;
            String aname = Account.class.getName();
            String abname = AccountBalance.class.getName();
            long id = Math.abs(((Object)((Object)this)).hashCode());
            try (Transaction tx2 = this.newTransaction("cache-bean-save");){
                account = new Account();
                account.setId(id);
                account.setFraud(new FraudJson(Collections.emptyMap()));
                account.setUsername("username_" + account.getId());
                account.setFirstName("f_" + account.getId());
                account.setLastName("l_" + account.getId());
                account.setDetails(Collections.emptyMap());
                AccountBalance balance1 = new AccountBalance(account, "USD");
                balance1.setAmount(BigDecimal.TEN);
                account.getBalances().add(balance1);
                AccountBalance balance2 = new AccountBalance(account, "EUR");
                balance2.setAmount(BigDecimal.ONE);
                account.getBalances().add(balance2);
                AccountBalance balance3 = new AccountBalance(account, "UAH");
                balance3.setAmount(BigDecimal.ONE);
                account.getBalances().add(balance3);
                this.ebean.save((Object)account);
                tx2.commit();
            }
            tx2 = this.newTransaction("cache-bean-save-all");
            try {
                for (Object it : this.ebean.find(Account.class).findList()) {
                    ((Account)it).setAge(((Account)it).getAge() + 1);
                    ((Account)it).setGameplayInfo(new GameplayInfo());
                    this.ebean.save(it, tx2);
                }
                tx2.commit();
            }
            finally {
                if (tx2 != null) {
                    tx2.close();
                }
            }
            for (i = 0; i < 10; ++i) {
                this.logger.debug("it ::: {}", (Object)i);
                tx = this.newReadOnlyTransaction("cache-bean-readonly");
                try {
                    tx.setReadOnly(true);
                    account = (Account)this.ebean.find(Account.class, (Object)id);
                    account.getBalances().size();
                    for (AccountBalance balance : account.getBalances()) {
                        balance.getAmount().toString();
                    }
                    continue;
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            for (i = 0; i < 10; ++i) {
                tx = this.newReadOnlyTransaction("cache-bean-readonly");
                try {
                    tx.setReadOnly(true);
                    Set accounts = this.ebean.createQuery(Account.class).setUseQueryCache(true).findSet();
                    accounts.size();
                    continue;
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            tx = this.newTransaction("cache-bean-save");
            try {
                account = (Account)this.ebean.find(Account.class, (Object)id);
                account.setAge(32);
                this.ebean.save((Object)account);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            Awaitility.await().atMost(Duration.ofSeconds(10L)).untilAsserted(new ThrowingRunnable(){

                public void run() throws Throwable {
                }
            });
            ServerCache aCache = this.manager.cache(aname + ServerCacheType.BEAN.code());
            ServerCache bCache = this.manager.cache(abname + ServerCacheType.BEAN.code());
            ServerCache cCache = this.manager.cache(aname + "." + QAccount.alias()._balances().toString() + ServerCacheType.COLLECTION_IDS.code());
            Assertions.assertEquals((int)1, (int)aCache.size());
            Assertions.assertEquals((int)2, (int)bCache.size());
            Assertions.assertEquals((int)1, (int)cCache.size());
            this.ebean.cacheManager().beanCache(Account.class).clear();
            Assertions.assertEquals((int)0, (int)aCache.size());
            Assertions.assertEquals((int)2, (int)bCache.size());
            Assertions.assertEquals((int)1, (int)cCache.size());
            this.ebean.cacheManager().beanCache(AccountBalance.class).clear();
            Assertions.assertEquals((int)0, (int)bCache.size());
            this.ebean.cacheManager().clear(Account.class);
            Assertions.assertEquals((int)0, (int)cCache.size());
        }
    }

    private static class CacheCleanBean
    extends AbstractEbeanAwareService
    implements InitializingBean {
        private final CacheManager manager;

        @Inject
        public CacheCleanBean(Database ebean, CacheManager manager) {
            super(ebean);
            this.manager = manager;
        }

        public void afterPropertiesSet() throws Exception {
            Account account;
            String aname = Account.class.getName();
            String abname = AccountBalance.class.getName();
            ServerCache aCache = this.manager.cache(aname + ServerCacheType.BEAN.code());
            ServerCache bCache = this.manager.cache(abname + ServerCacheType.BEAN.code());
            long id = Math.abs(((Object)((Object)this)).hashCode());
            try (Transaction tx = this.newTransaction("save");){
                account = new Account();
                account.setId(id);
                account.setUsername("username_" + account.getId());
                account.setFirstName("f_" + account.getId());
                account.setLastName("l_" + account.getId());
                AccountBalance balance1 = new AccountBalance(account, "USD");
                balance1.setAmount(BigDecimal.TEN);
                account.getBalances().add(balance1);
                AccountBalance balance2 = new AccountBalance(account, "EUR");
                balance2.setAmount(BigDecimal.ONE);
                account.getBalances().add(balance2);
                this.ebean.save((Object)account);
                tx.commit();
            }
            for (int i = 0; i < 10; ++i) {
                this.logger.debug("it ::: {}", (Object)i);
                try (Transaction tx = this.ebean.beginTransaction();){
                    account = (Account)this.ebean.find(Account.class, (Object)id);
                    account.getBalances().size();
                    for (AccountBalance balance : account.getBalances()) {
                        balance.getAmount().toString();
                    }
                    continue;
                }
            }
            CacheCleanTask action = new CacheCleanTask((Database)this.ebean, Account.class, (Object)account.getId(), new TQAssocBean[]{QAccount.alias()._balances()});
            action.run();
            Assertions.assertEquals((int)0, (int)aCache.size());
            Assertions.assertEquals((int)2, (int)bCache.size());
        }
    }

    private static class RollbackBean
    extends AbstractEbeanAwareService
    implements InitializingBean {
        private final CacheManager manager;

        @Inject
        public RollbackBean(Database ebean, CacheManager manager) {
            super(ebean);
            this.manager = manager;
        }

        public void afterPropertiesSet() throws Exception {
            String tname = UTMTemplate.class.getName();
            long id = Math.abs(((Object)((Object)this)).hashCode());
            try (Transaction tx = this.newTransaction("cache-bean-save");){
                Account account = new Account();
                account.setId(id);
                account.setFraud(new FraudJson(Collections.emptyMap()));
                account.setUsername("username_" + account.getId());
                account.setFirstName("f_" + account.getId());
                account.setLastName("l_" + account.getId());
                account.setDetails(Collections.emptyMap());
                this.ebean.save((Object)account);
                tx.flush();
                UTMTemplate template1 = new UTMTemplate(account, "utm-1");
                this.ebean.save((Object)template1, tx);
                UTMTemplate template2 = new UTMTemplate(account, "utm-2");
                this.ebean.save((Object)template2, tx);
                this.ebean.createQuery(UTMTemplate.class).usingTransaction(tx).where().eq("account", (Object)account).eq("campaign", (Object)template1.getCampaign()).findOne();
                this.ebean.createQuery(UTMTemplate.class).usingTransaction(tx).where().eq("account", (Object)account).eq("campaign", (Object)template2.getCampaign()).findOne();
                UTMTemplate template3 = new UTMTemplate(account, "utm-2");
                this.ebean.save((Object)template3, tx);
                tx.rollback();
            }
            catch (DuplicateKeyException err) {
                this.logger.warn(err.getMessage(), (Throwable)err);
            }
            ServerCache tCache = this.manager.cache(tname + ServerCacheType.BEAN.code());
            Assertions.assertEquals((int)2, (int)tCache.size());
        }
    }
}

