package com.turbospaces.ebean;

import java.util.Collection;
import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.ImmutableList;

import io.ebean.Database;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheManager;
import io.ebean.typequery.TQAssocBean;

public class CacheCleanTask implements Runnable {
    private static Logger LOGGER = LoggerFactory.getLogger( CacheCleanTask.class );

    private final Database ebean;
    private final Object id;
    private final Class<?> root;
    private final Collection<TQAssocBean<?, ?>> assocs;

    public CacheCleanTask(Database ebean, Class<?> root, Object id, TQAssocBean<?, ?>... assocs) {
        this.ebean = Objects.requireNonNull( ebean );
        this.id = Objects.requireNonNull( id );
        this.root = Objects.requireNonNull( root );
        this.assocs = ImmutableList.copyOf( assocs );
    }
    @Override
    public void run() {
        ServerCacheManager manager = ebean.cacheManager();
        ServerCache beanCache = manager.beanCache( root );

        if ( beanCache != null ) {
            if ( LOGGER.isDebugEnabled() ) {
                Object removeReturn = beanCache.get( id );
                LOGGER.debug( "invalidate {}:{} -> ({})", beanCache.toString(), id, removeReturn );
            }
            beanCache.remove( id );
        }

        if ( assocs != null ) {
            for ( TQAssocBean<?, ?> assoc : assocs ) {
                ServerCache idsCache = manager.collectionIdsCache( root, assoc.toString() );
                if ( idsCache != null ) {
                    if ( LOGGER.isDebugEnabled() ) {
                        Object removeReturn = idsCache.get( id );
                        LOGGER.debug( "invalidate collection {}:{} -> ({})", idsCache.toString(), id, removeReturn );
                    }
                    idsCache.remove( id );
                }
            }
        }
    }
}
