/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.collect.ImmutableList;
import io.ebean.Database;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheManager;
import io.ebean.typequery.TQAssocBean;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCleanTask
implements Runnable {
    private static Logger LOGGER = LoggerFactory.getLogger(CacheCleanTask.class);
    private final Database ebean;
    private final Object id;
    private final Class<?> root;
    private final Collection<TQAssocBean<?, ?>> assocs;

    public CacheCleanTask(Database ebean, Class<?> root, Object id, TQAssocBean<?, ?> ... assocs) {
        this.ebean = Objects.requireNonNull(ebean);
        this.id = Objects.requireNonNull(id);
        this.root = Objects.requireNonNull(root);
        this.assocs = ImmutableList.copyOf((Object[])assocs);
    }

    @Override
    public void run() {
        ServerCacheManager manager = this.ebean.cacheManager();
        ServerCache beanCache = manager.beanCache(this.root);
        if (beanCache != null) {
            if (LOGGER.isDebugEnabled()) {
                Object removeReturn = beanCache.get(this.id);
                LOGGER.debug("invalidate {}:{} -> ({})", new Object[]{beanCache.toString(), this.id, removeReturn});
            }
            beanCache.remove(this.id);
        }
        if (this.assocs != null) {
            for (TQAssocBean<?, ?> assoc : this.assocs) {
                ServerCache idsCache = manager.collectionIdsCache(this.root, assoc.toString());
                if (idsCache == null) continue;
                if (LOGGER.isDebugEnabled()) {
                    Object removeReturn = idsCache.get(this.id);
                    LOGGER.debug("invalidate collection {}:{} -> ({})", new Object[]{idsCache.toString(), this.id, removeReturn});
                }
                idsCache.remove(this.id);
            }
        }
    }
}

