/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.DefaultEbeanCacheManager;
import com.turbospaces.ebean.RpcDispatcherDisposableBean;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.BootstrapContextClosedEvent;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;

public class CacheBootstrapInitializer
extends AbstractBootstrapAware
implements BootstrapRegistryInitializer {
    private final RpcDispatcher dispatcher = new RpcDispatcher();
    private DefaultEbeanCacheManager manager;

    public void setBootstrap(Bootstrap bootstrap) {
        super.setBootstrap(bootstrap);
        this.manager = new DefaultEbeanCacheManager(this.dispatcher, bootstrap.isDevMode() ? RequestOptions.SYNC() : RequestOptions.ASYNC());
        this.manager.setBootstrap(bootstrap);
    }

    public void initialize(final BootstrapRegistry registry) {
        registry.register(CacheManager.class, BootstrapRegistry.InstanceSupplier.of((Object)this.manager));
        registry.addCloseListener((ApplicationListener)new ApplicationListener<BootstrapContextClosedEvent>(){

            public void onApplicationEvent(BootstrapContextClosedEvent event) {
                BootstrapRegistry.InstanceSupplier supplier = registry.getRegisteredInstanceSupplier(JChannel.class);
                JChannel jchannel = (JChannel)supplier.get(event.getBootstrapContext());
                ConfigurableApplicationContext applicationContext = event.getApplicationContext();
                applicationContext.addApplicationListener((ApplicationListener)new SmartApplicationListener(){

                    public void onApplicationEvent(ApplicationEvent e) {
                        CacheBootstrapInitializer.this.dispatcher.stop();
                    }

                    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
                        return eventType.equals(ApplicationFailedEvent.class);
                    }
                });
                CacheBootstrapInitializer.this.dispatcher.setChannel(jchannel);
                CacheBootstrapInitializer.this.dispatcher.setServerObject((Object)CacheBootstrapInitializer.this.manager);
                CacheBootstrapInitializer.this.dispatcher.setMethodLookup((MethodLookup)CacheBootstrapInitializer.this.manager);
                CacheBootstrapInitializer.this.dispatcher.setMembershipListener(new MembershipListener(){

                    public void viewAccepted(View view) {
                        CacheBootstrapInitializer.this.logger.debug("new view: {}", (Object)view);
                    }

                    public void suspect(Address member) {
                        CacheBootstrapInitializer.this.logger.debug("suspected member: {}", (Object)member);
                    }
                });
                CacheBootstrapInitializer.this.dispatcher.start();
                DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getBeanFactory();
                beanFactory.registerSingleton("rpc-dispatcher", (Object)CacheBootstrapInitializer.this.dispatcher);
                beanFactory.registerSingleton("cache-manager", (Object)CacheBootstrapInitializer.this.manager);
                GenericBeanDefinition bean = new GenericBeanDefinition();
                bean.setBeanClass(RpcDispatcherDisposableBean.class);
                bean.setAutowireCandidate(true);
                beanFactory.registerBeanDefinition("rpc-dispatcher-lifecycle", (BeanDefinition)bean);
            }
        });
    }
}

