package com.turbospaces.ebean;

import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Version;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.turbospaces.common.PlatformUtil;

import io.ebean.annotation.Cache;
import io.ebean.annotation.DbJsonB;
import io.ebean.annotation.WhenCreated;
import io.ebean.annotation.WhenModified;

@Entity
@Table(name = "account", schema = "CORE")
@Cache(enableQueryCache = true)
public class Account {
    @Id
    private long id;

    @Column(unique = true)
    private String username;

    private String firstName;
    private String lastName;
    private int age;
    private LocalDate birthDate;

    @OneToMany(mappedBy = "account", cascade = CascadeType.ALL)
    private Set<AccountBalance> balances;

    @DbJsonB
    private Map<String, Object> details;

    @WhenCreated
    @Column(nullable = false)
    private Date createdAt;

    @WhenModified
    @Column(nullable = false)
    private Date modifiedAt;

    @Version
    private int version;

    public long getId() {
        return id;
    }
    public void setId(long id) {
        this.id = id;
    }
    public String getUsername() {
        return username;
    }
    public void setUsername(String username) {
        this.username = username;
    }
    public String getFirstName() {
        return firstName;
    }
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }
    public String getLastName() {
        return lastName;
    }
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
    public LocalDate getBirthDate() {
        return birthDate;
    }
    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }
    public int getAge() {
        return age;
    }
    public void setAge(int age) {
        this.age = age;
    }
    public Set<AccountBalance> getBalances() {
        return balances;
    }
    public void setBalances(Set<AccountBalance> balances) {
        this.balances = balances;
    }
    public Map<String, Object> getDetails() {
        return details;
    }
    public void setDetails(Map<String, Object> details) {
        this.details = details;
    }
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }
    public Date getCreatedAt() {
        return createdAt;
    }
    public Date getModifiedAt() {
        return modifiedAt;
    }
    public int getVersion() {
        return version;
    }
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append( getUsername() ).build();
    }
    @Override
    public boolean equals(Object obj) {
        Account other = (Account) obj;
        return new EqualsBuilder().append( getUsername(), other.getUsername() ).isEquals();
    }
    @Override
    public String toString() {
        ToStringBuilder toString = PlatformUtil.noClassNameToString( this );
        return toString.append( "id", getId() ).append( "username", getUsername() ).append( "version", getVersion() ).build();
    }
}
