/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ebean.Account;
import com.turbospaces.ebean.AccountBalance;
import com.turbospaces.ebean.AccountBalanceId;
import com.turbospaces.ebean.AccountBalanceSnapshot;
import com.turbospaces.ebean.AccountBalanceSnapshotId;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.DefaultEbeanCacheConfigurer;
import com.turbospaces.ebean.EbeanDatabaseConfig;
import com.turbospaces.ebean.EbeanFactoryBean;
import com.turbospaces.ebean.FraudJson;
import com.turbospaces.ebean.GameplayInfo;
import com.turbospaces.ebean.JGroupCacheManagerFactoryBean;
import com.turbospaces.ebean.UTMTemplate;
import com.turbospaces.ebean.query.QAccount;
import com.turbospaces.ebean.query.QAccountBalance;
import com.turbospaces.jdbc.HikariDataSourceFactoryBean;
import com.turbospaces.jgroups.JGroupsFactoryBean;
import com.turbospaces.plugins.FlywayBootstrapInitializer;
import com.turbospaces.ups.UPSs;
import io.ebean.Database;
import io.ebean.ProfileLocation;
import io.ebean.bean.EnhancedTransactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneOffset;
import javax.sql.DataSource;
import org.jgroups.JChannel;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;

public class CompositeKeyTest
implements EnhancedTransactional {
    private static /* synthetic */ ProfileLocation _$ebpq0;

    @Test
    public void works() throws Throwable {
        MockCloud builder = MockCloud.newMock();
        ApplicationConfig cfg = builder.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        DefaultEbeanCacheConfigurer mngr = new DefaultEbeanCacheConfigurer(props);
        mngr.setMaxSize(Account.class, 1);
        mngr.setMaxSize(Account.class, QAccount.alias()._balances(), 1);
        mngr.setMaxSize(UTMTemplate.class, 8);
        mngr.setMaxSize(AccountBalance.class, 10);
        mngr.setMaxSize(AccountBalance.class, QAccountBalance.alias()._snapshots(), 10);
        mngr.setMaxSize(AccountBalanceSnapshot.class, 30);
        mngr.setMaxSize(Account.class, QAccount.alias()._utmTemplates(), Integer.MAX_VALUE);
        mngr.setMaxSizeQuery(Account.class, 1);
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg), new Class[]{AppConfig.class});
        bootstrap.withH2(true, bootstrap.spaceName());
        ServiceInfo ownerUps = UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)"h2-owner");
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new FlywayBootstrapInitializer(ownerUps, new String[]{"CORE"}));
        ConfigurableApplicationContext applicationContext = bootstrap.run(new String[0]);
        Database ebean = (Database)applicationContext.getBean(Database.class);
        Account account = new Account();
        account.setId(System.currentTimeMillis());
        account.setUsername("username_" + account.getId());
        account.setFirstName("f_" + account.getId());
        account.setLastName("l_" + account.getId());
        account.setAge(18);
        account.setBirthDate(LocalDate.now(ZoneOffset.UTC).minusYears(account.getAge()));
        ebean.save((Object)account);
        AccountBalance balance = new AccountBalance(account, "USD");
        balance.setAmount(BigDecimal.ONE);
        AccountBalanceSnapshot snapshot1 = new AccountBalanceSnapshot(balance, LocalDate.now(ZoneOffset.UTC));
        AccountBalanceSnapshot snapshot2 = new AccountBalanceSnapshot(balance, LocalDate.now(ZoneOffset.UTC).plusDays(1L));
        balance.getSnapshots().add(snapshot1);
        balance.getSnapshots().add(snapshot2);
        ebean.save((Object)balance);
        QAccountBalance q = (QAccountBalance)((Object)new QAccountBalance(ebean).setProfileLocation(_$ebpq0));
        q.setId(balance.getPk());
        q.findList();
        bootstrap.shutdown();
    }

    static {
        CompositeKeyTest._$ebpq0 = ProfileLocation.create();
    }

    @Configurable
    public static class AppConfig
    extends AbstractBootstrapAware {
        @Bean
        public HikariDataSourceFactoryBean ds() {
            ServiceInfo appUps = UPSs.findRequiredServiceInfoByName((Bootstrap)this.bootstrap, (String)"h2-app");
            return new HikariDataSourceFactoryBean(appUps);
        }

        @Bean
        public JGroupsFactoryBean jgroups() {
            return new JGroupsFactoryBean();
        }

        @Bean
        public JGroupCacheManagerFactoryBean cacheManager(JGroupsFactoryBean factory) throws Exception {
            return new JGroupCacheManagerFactoryBean((JChannel)factory.getObject());
        }

        @Bean
        public EbeanDatabaseConfig ebeanConfig(HikariDataSourceFactoryBean factory) throws Exception {
            EbeanDatabaseConfig cfg = new EbeanDatabaseConfig((DataSource)factory.getObject(), this.bootstrap.props());
            cfg.addClass(Account.class);
            cfg.addClass(GameplayInfo.class);
            cfg.addClass(FraudJson.class);
            cfg.addClass(UTMTemplate.class);
            cfg.addClass(AccountBalance.class);
            cfg.addClass(AccountBalanceId.class);
            cfg.addClass(AccountBalanceSnapshot.class);
            cfg.addClass(AccountBalanceSnapshotId.class);
            return cfg;
        }

        @Bean
        public EbeanFactoryBean ebean(EbeanDatabaseConfig config, JGroupCacheManagerFactoryBean cache) throws Exception {
            return new EbeanFactoryBean(config, (CacheManager)cache.getObject());
        }
    }
}

