package com.turbospaces.ebean;

import com.google.common.annotations.VisibleForTesting;

import io.ebean.BackgroundExecutor;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCachePlugin;

public interface CacheManager extends ServerCachePlugin, ServerCacheFactory {
    void setBackgroundExecutor(BackgroundExecutor executor);
    SimpleCache createSimpleCache(String name);

    @VisibleForTesting
    ServerCache getCache(String string);

    void clearAllLocal();
    void clearAllSimple();
    void clearAll(boolean preserveSimple);

    default void onCachePut(String cacheKey, byte[] id, byte[] value) {}
    default void onCacheRemove(String cacheKey, byte[] id) {}
    default void onCacheClear(String cacheKey) {}
    default void onCacheClearAll(boolean preserveSimple) {}
    default void onTablesModify(String tables) {}
}
