package com.turbospaces.ebean;

import java.util.Objects;

import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;

import io.ebean.cache.ServerCacheType;
import io.ebean.typequery.TQAssocBean;

public class DefaultEbeanCacheConfigurer implements EbeanCacheConfigurer {
    private final ApplicationProperties props;

    public DefaultEbeanCacheConfigurer(ApplicationProperties props) {
        this.props = Objects.requireNonNull( props );
    }
    @Override
    public ApplicationConfig cfg() {
        return props.cfg();
    }
    @Override
    public ApplicationProperties props() {
        return props;
    }
    @Override
    public void setMaxIdle(Class<?> clazz, int value) {
        String prefix = clazz.getName() + ServerCacheType.BEAN.code();
        cfg().setDefaultProperty( prefix + "." + MAX_IDLE, value );
    }
    @Override
    public void setMaxTTL(Class<?> clazz, int value) {
        String prefix = clazz.getName() + ServerCacheType.BEAN.code();
        cfg().setDefaultProperty( prefix + "." + MAX_TTL, value );
    }
    @Override
    public void setMaxSize(Class<?> clazz, int value) {
        String bprefix = clazz.getName() + ServerCacheType.BEAN.code();
        String nprefix = clazz.getName() + ServerCacheType.NATURAL_KEY.code();
        cfg().setDefaultProperty( bprefix + "." + MAX_SIZE, value );
        cfg().setDefaultProperty( nprefix + "." + MAX_SIZE, value );
    }
    @Override
    public void setMaxSizeQuery(Class<?> clazz, int value) {
        String prefix = clazz.getName() + ServerCacheType.QUERY.code();
        cfg().setDefaultProperty( prefix + "." + MAX_SIZE, value );
    }
    @Override
    public void setCacheMode(Class<?> clazz, boolean local) {
        String prefix = clazz.getName() + ServerCacheType.BEAN.code();
        cfg().setDefaultProperty( prefix + "." + CACHE_MODE_LOCAL, local );
    }
    @Override
    public void setMaxIdle(Class<?> clazz, TQAssocBean<?, ?> assoc, int value) {
        String prefix = clazz.getName() + "." + assoc.toString() + ServerCacheType.COLLECTION_IDS.code();
        cfg().setDefaultProperty( prefix + "." + MAX_IDLE, value );
    }
    @Override
    public void setMaxTTL(Class<?> clazz, TQAssocBean<?, ?> assoc, int value) {
        String prefix = clazz.getName() + "." + assoc.toString() + ServerCacheType.COLLECTION_IDS.code();
        cfg().setDefaultProperty( prefix + "." + MAX_TTL, value );
    }
    @Override
    public void setMaxSize(Class<?> clazz, TQAssocBean<?, ?> assoc, int value) {
        String prefix = clazz.getName() + "." + assoc.toString() + ServerCacheType.COLLECTION_IDS.code();
        cfg().setDefaultProperty( prefix + "." + MAX_SIZE, value );
    }
    @Override
    public void setCacheMode(Class<?> clazz, TQAssocBean<?, ?> assoc, boolean local) {
        String prefix = clazz.getName() + "." + assoc.toString() + ServerCacheType.COLLECTION_IDS.code();
        cfg().setDefaultProperty( prefix + "." + CACHE_MODE_LOCAL, local );
    }
}
