/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.google.common.collect.ImmutableList;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.turbospaces.ebean.LocalCache;
import io.ebean.cache.ServerCacheStatistics;
import java.util.Iterator;
import java.util.Objects;

public class RuntimeConfigCache
implements LocalCache {
    private final DefaultSettableConfig cfg;

    public RuntimeConfigCache(DefaultSettableConfig cfg) {
        this.cfg = Objects.requireNonNull(cfg);
    }

    public Object get(Object id) {
        return this.cfg.getRawProperty(id.toString());
    }

    public void put(Object id, Object value) {
        this.cfg.setProperty(id.toString(), (Object)value.toString());
    }

    public void remove(Object id) {
        this.cfg.clearProperty(id.toString());
    }

    public void clear() {
        Iterator it = this.cfg.getKeys();
        for (String key : ImmutableList.copyOf((Iterator)it)) {
            this.cfg.clearProperty(key);
        }
    }

    @Override
    public int onClear() {
        Iterator keys = this.cfg.getKeys();
        int counter = 0;
        while (keys.hasNext()) {
            keys.next();
            ++counter;
        }
        this.clear();
        return counter;
    }

    public int size() {
        return ImmutableList.copyOf((Iterator)this.cfg.getKeys()).size();
    }

    public int hitRatio() {
        return 0;
    }

    public ServerCacheStatistics statistics(boolean reset) {
        return null;
    }
}

