package com.turbospaces.ebean;

import java.util.Iterator;
import java.util.Objects;

import com.google.common.collect.ImmutableList;
import com.netflix.archaius.config.DefaultSettableConfig;

import io.ebean.cache.ServerCacheStatistics;

public class RuntimeConfigCache implements LocalCache {
    private final DefaultSettableConfig cfg;

    public RuntimeConfigCache(DefaultSettableConfig cfg) {
        this.cfg = Objects.requireNonNull(cfg);
    }
    @Override
    public Object get(Object id) {
        return cfg.getRawProperty(id.toString());
    }
    @Override
    public void put(Object id, Object value) {
        cfg.setProperty(id.toString(), value.toString());
    }
    @Override
    public void remove(Object id) {
        cfg.clearProperty(id.toString());
    }
    @Override
    public void clear() {
        Iterator<String> it = cfg.getKeys();
        for (String key : ImmutableList.copyOf(it)) {
            cfg.clearProperty(key);
        }
    }
    @Override
    public int onClear() {
        Iterator<String> keys = cfg.getKeys();
        int counter = 0;
        while ( keys.hasNext() ) {
            keys.next();
            counter++;
        }
        clear();
        return counter;
    }
    @Override
    public int size() {
        return ImmutableList.copyOf(cfg.getKeys()).size();
    }
    @Override
    public int hitRatio() {
        return 0;
    }
    @Override
    public ServerCacheStatistics statistics(boolean reset) {
        return null;
    }
}
