/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ebean;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.ebean.CacheManager;
import com.turbospaces.ebean.JGroupsCacheManager;
import io.ebean.BackgroundExecutor;
import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class JGroupCacheManagerFactoryBean
extends AbstractFactoryBean<CacheManager>
implements BootstrapAware {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RpcDispatcher dispatcher = new RpcDispatcher();
    private final JChannel jchannel;
    private BackgroundExecutor backgroundExecutor;
    private Bootstrap bootstrap;

    public JGroupCacheManagerFactoryBean(JChannel jchannel) {
        this.jchannel = Objects.requireNonNull(jchannel);
    }

    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void setBackgroundExecutor(BackgroundExecutor backgroundExecutor) {
        this.backgroundExecutor = backgroundExecutor;
    }

    public Class<?> getObjectType() {
        return CacheManager.class;
    }

    protected CacheManager createInstance() throws Exception {
        JGroupsCacheManager manager = new JGroupsCacheManager(this.dispatcher, this.bootstrap.isDevMode() ? RequestOptions.SYNC() : RequestOptions.ASYNC());
        manager.setBootstrap(this.bootstrap);
        if (Objects.nonNull(this.backgroundExecutor)) {
            manager.setBackgroundExecutor(this.backgroundExecutor);
        }
        this.dispatcher.setChannel(this.jchannel);
        this.dispatcher.setServerObject((Object)manager);
        this.dispatcher.setMethodLookup((MethodLookup)manager);
        this.dispatcher.setMembershipListener(new MembershipListener(){

            public void viewAccepted(View view) {
                JGroupCacheManagerFactoryBean.this.log.debug("new view: {}", (Object)view);
            }

            public void suspect(Address member) {
                JGroupCacheManagerFactoryBean.this.log.debug("suspected member: {}", (Object)member);
            }
        });
        this.dispatcher.start();
        return manager;
    }

    protected void destroyInstance(CacheManager instance) throws Exception {
        this.dispatcher.close();
    }
}

