package com.turbospaces.ebean;

import java.util.Map.Entry;

import org.jgroups.Address;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.slf4j.Logger;

import io.ebean.cache.ServerCacheType;

public interface ReplicatedCache extends LocalCache {
    void onPut(byte[] key, byte[] value);
    void onRemove(byte[] key);
    ServerCacheType type();

    static void trace(Logger logger, RspList<Object> l) {
        for (Entry<Address, Rsp<Object>> it : l.entrySet()) {
            Address address = it.getKey();
            Rsp<Object> rsp = it.getValue();
            if (rsp.hasException()) {
                logger.error("{} : {}", address, rsp);
            } else {
                logger.trace("{} : {}", address, rsp);
            }
        }
    }
}
