package com.turbospaces;

import javax.persistence.Column;
import javax.persistence.Embeddable;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Embeddable
public class AccountBalanceId {
    @Column(nullable = false)
    private Long accountId;

    @Column(nullable = false)
    private String currency;

    public AccountBalanceId() {}
    public AccountBalanceId(Account account, String currency) {
        this.accountId = account.getId();
        this.currency = currency;
    }
    public Long getAccountId() {
        return accountId;
    }
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getCurrency() {
        return currency;
    }
    public void setCurrency(String currency) {
        this.currency = currency;
    }
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getAccountId()).append(getCurrency()).toHashCode();
    }
    @Override
    public boolean equals(Object obj) {
        AccountBalanceId other = (AccountBalanceId) obj;
        return new EqualsBuilder().append(getAccountId(), other.getAccountId()).append(getCurrency(), other.getCurrency()).isEquals();
    }
}
