package com.turbospaces;

import javax.sql.DataSource;

import com.turbospaces.ebean.AbstractEbeanFactoryBean;
import com.turbospaces.ebean.EbeanJpaManager;
import com.turbospaces.ebean.JpaManager;

import io.ebean.Database;
import io.ebean.config.DatabaseConfig;

public class EbeanFactoryBean extends AbstractEbeanFactoryBean<JpaManager> {
    public EbeanFactoryBean(DataSource ds) {
        super(ds);
    }
    @Override
    public Class<?> getObjectType() {
        return JpaManager.class;
    }
    @Override
    protected void configure(DatabaseConfig config) throws Exception {}
    @Override
    protected JpaManager createEbean(Database db) throws Exception {
        return new EbeanJpaManager(db, bootstrap.tracer());
    }
}
