package com.turbospaces.boot;

import java.util.Objects;

import javax.annotation.OverridingMethodsMustInvokeSuper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBootstrapAware implements BootstrapAware {
    protected final Logger logger = LoggerFactory.getLogger(getClass());
    protected Bootstrap bootstrap;

    @OverridingMethodsMustInvokeSuper
    @Override
    public void setBootstrap(Bootstrap bootstrap) throws Throwable {
        this.bootstrap = Objects.requireNonNull(bootstrap);
    }
}
