/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.executor;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.executor.DefaultPlatformExecutorService;
import io.vavr.CheckedRunnable;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurablePlatformTest {
    private static final Logger log = LoggerFactory.getLogger(ConfigurablePlatformTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        cfg.setLocalProperty(props.APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.getKey(), (Object)Duration.ofSeconds(1L));
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        DefaultPlatformExecutorService platform = new DefaultPlatformExecutorService("test", 1, 2);
        platform.setBootstrap((Bootstrap)bootstrap);
        platform.afterPropertiesSet();
        try {
            final CountDownLatch semaphore = new CountDownLatch(1);
            final CountDownLatch l = new CountDownLatch(1);
            final CountDownLatch interrupted = new CountDownLatch(1);
            platform.submit(new CheckedRunnable(){

                public void run() throws Exception {
                    System.out.println(Thread.currentThread().getName() + " ::: work");
                    Assertions.assertTrue((boolean)semaphore.await(30L, TimeUnit.SECONDS));
                    l.countDown();
                }
            });
            platform.execute(new Runnable(){

                @Override
                public void run() {
                    System.out.println(Thread.currentThread().getName() + " ::: execute");
                    semaphore.countDown();
                }
            });
            Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
            final CountDownLatch started = new CountDownLatch(1);
            platform.submit(new CheckedRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            log.debug("about to hang forever ...");
                            Thread.sleep(1000L);
                            log.debug("count down to mark started ...");
                            started.countDown();
                            this.wait();
                        }
                        catch (InterruptedException err) {
                            interrupted.countDown();
                        }
                    }
                }
            });
            Assertions.assertTrue((boolean)started.await(30L, TimeUnit.SECONDS));
            platform.destroy();
            Assertions.assertTrue((boolean)interrupted.await(30L, TimeUnit.SECONDS));
        }
        finally {
            bootstrap.shutdown();
        }
    }
}

