package com.turbospaces.ups;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

import org.springframework.cloud.service.ServiceInfo;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;

public class RawServiceInfo implements ServiceInfo {
    private final String id;
    private final byte[] payload;

    public RawServiceInfo(String id, byte[] payload) {
        this.id = Objects.requireNonNull(id);
        this.payload = Arrays.copyOf(payload, payload.length);
    }
    @Override
    public String getId() {
        return id;
    }
    public String read() throws IOException {
        return toByteSource().asCharSource(StandardCharsets.UTF_8).read();
    }
    public ImmutableList<String> readLines() throws IOException {
        return toByteSource().asCharSource(StandardCharsets.UTF_8).readLines();
    }
    public BufferedReader openBufferedStream() throws IOException {
        return toByteSource().asCharSource(StandardCharsets.UTF_8).openBufferedStream();
    }
    public ByteSource toByteSource() {
        return ByteSource.wrap(payload);
    }
}
