/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.rpc;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Timestamp;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.dispatch.WorkerCompletableTasksBatch;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerCompletableTasksBatchTest {
    private static final Logger log = LoggerFactory.getLogger(WorkerCompletableTasksBatchTest.class);

    @Test
    public void empty() throws InterruptedException {
        WorkerCompletableTasksBatch batch = new WorkerCompletableTasksBatch(ImmutableMap.builder());
        Assertions.assertTrue((boolean)batch.awaitAndJustLogIncomplete(log, (Supplier)Suppliers.ofInstance((Object)1), TimeUnit.NANOSECONDS));
    }

    @Test
    public void one() throws InterruptedException {
        SettableFuture f = SettableFuture.create();
        ImmutableMap map = ImmutableMap.builder().put((Object)PlatformUtil.randomUUID().toString(), (Object)f).build();
        WorkerCompletableTasksBatch batch = new WorkerCompletableTasksBatch((Map)map);
        f.set((Object)Timestamp.newBuilder().setNanos((int)System.nanoTime()).build());
        Assertions.assertTrue((boolean)batch.awaitAndJustLogIncomplete(log, (Supplier)Suppliers.ofInstance((Object)1), TimeUnit.NANOSECONDS));
    }

    @Test
    public void exceptional() throws InterruptedException {
        SettableFuture f = SettableFuture.create();
        ImmutableMap map = ImmutableMap.builder().put((Object)PlatformUtil.randomUUID().toString(), (Object)f).build();
        WorkerCompletableTasksBatch batch = new WorkerCompletableTasksBatch((Map)map);
        Assertions.assertFalse((boolean)batch.awaitAndJustLogIncomplete(log, (Supplier)Suppliers.ofInstance((Object)1), TimeUnit.NANOSECONDS));
    }
}

