/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.CustomRetryRegistry;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import io.github.resilience4j.core.IntervalBiFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomRetryRegistryTest {
    @Test
    void testRetryDefaultConfig() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        ApplicationProperties props = new ApplicationProperties(cfg.factory());
        CustomRetryRegistry retryRegistry = new CustomRetryRegistry(props);
        Retry retryWithDefaultConfig = retryRegistry.retry("retry-without-special-config");
        Integer maxAttempts = (Integer)props.APP_BACKOFF_RETRY_NUM.get();
        Duration initialDelay = (Duration)props.APP_BACKOFF_RETRY_FIRST.get();
        Duration maxDelay = (Duration)props.APP_BACKOFF_RETRY_MAX.get();
        RetryConfig config = retryWithDefaultConfig.getRetryConfig();
        IntervalBiFunction intervalBiFunction = config.getIntervalBiFunction();
        Assertions.assertEquals((Integer)maxAttempts, (int)config.getMaxAttempts());
        CustomRetryRegistryTest.checkIntervalFunction(config.getMaxAttempts(), (IntervalBiFunction<Object>)intervalBiFunction, initialDelay.toMillis(), maxDelay.toMillis());
    }

    @Test
    void testRetryDynamicConfig() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        ApplicationProperties props = new ApplicationProperties(cfg.factory());
        String testRetryName = "test-retry";
        Duration initialDelay = Duration.ofMillis(2L);
        Duration maxDelay = Duration.ofMillis(3L);
        int maxAttempts = 3;
        cfg.setLocalProperty(testRetryName + "." + props.APP_BACKOFF_RETRY_FIRST.getKey(), (Object)initialDelay);
        cfg.setLocalProperty(testRetryName + "." + props.APP_BACKOFF_RETRY_MAX.getKey(), (Object)maxDelay);
        cfg.setLocalProperty(testRetryName + "." + props.APP_BACKOFF_RETRY_NUM.getKey(), (Object)maxAttempts);
        CustomRetryRegistry retryRegistry = new CustomRetryRegistry(props);
        Retry retryWithDefaultConfig = retryRegistry.retry(testRetryName);
        RetryConfig config = retryWithDefaultConfig.getRetryConfig();
        IntervalBiFunction intervalBiFunction = config.getIntervalBiFunction();
        Assertions.assertEquals((int)maxAttempts, (int)config.getMaxAttempts());
        CustomRetryRegistryTest.checkIntervalFunction(config.getMaxAttempts(), (IntervalBiFunction<Object>)intervalBiFunction, initialDelay.toMillis(), maxDelay.toMillis());
    }

    @Test
    void testDynamicRetryWithInitialDelayOverridden() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        ApplicationProperties props = new ApplicationProperties(cfg.factory());
        String testRetryName = "test-retry-with-custom-initial-delay";
        Duration initialDelay = Duration.ofMillis(100L);
        Duration maxDelay = (Duration)props.APP_BACKOFF_RETRY_MAX.get();
        Integer maxAttempts = (Integer)props.APP_BACKOFF_RETRY_NUM.get();
        cfg.setLocalProperty(testRetryName + "." + props.APP_BACKOFF_RETRY_FIRST.getKey(), (Object)initialDelay);
        CustomRetryRegistry retryRegistry = new CustomRetryRegistry(props);
        Retry retryWithDefaultConfig = retryRegistry.retry(testRetryName);
        RetryConfig config = retryWithDefaultConfig.getRetryConfig();
        IntervalBiFunction intervalBiFunction = config.getIntervalBiFunction();
        Assertions.assertEquals((Integer)maxAttempts, (int)config.getMaxAttempts());
        CustomRetryRegistryTest.checkIntervalFunction(config.getMaxAttempts(), (IntervalBiFunction<Object>)intervalBiFunction, initialDelay.toMillis(), maxDelay.toMillis());
    }

    private static void checkIntervalFunction(int maxAttempts, IntervalBiFunction<Object> intervalBiFunction, long expectedInitialDelay, long maxDelay) {
        long expectedValue = expectedInitialDelay;
        int i = 1;
        do {
            Assertions.assertEquals((long)expectedValue, (Long)((Long)intervalBiFunction.apply((Object)i, null)));
            expectedValue = (long)((double)expectedValue * 1.5);
            expectedValue = Math.min(expectedValue, maxDelay);
        } while (++i <= maxAttempts);
    }
}

