/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.netflix.archaius.api.annotations.Configuration;
import com.turbospaces.annotations.Retryable;
import com.turbospaces.aspects.RetryAspect;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

class RetryAspectTest {
    RetryAspectTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testRetriedOnce() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg.factory()), new Class[]{AppConfig.class});
        ConfigurableApplicationContext applicationContext = bootstrap.run(new String[0]);
        try {
            ServiceApi serviceApi = (ServiceApi)applicationContext.getBean(ServiceApi.class);
            serviceApi.failOnce();
            Assertions.assertEquals((int)2, (int)ServiceApi.ATTEMPTED_COUNT.getAndSet(0));
            Assertions.assertEquals((double)1.0, (double)bootstrap.meterRegistry().get("resilience4j.retry.calls").tags(new String[]{"name", "ServiceApi_failOnce_default", "kind", "successful_with_retry"}).functionCounter().count());
            Assertions.assertEquals((double)0.0, (double)bootstrap.meterRegistry().get("resilience4j.retry.calls").tags(new String[]{"name", "ServiceApi_failOnce_default", "kind", "failed_with_retry"}).functionCounter().count());
            Assertions.assertEquals((double)0.0, (double)bootstrap.meterRegistry().get("resilience4j.retry.calls").tags(new String[]{"name", "ServiceApi_failOnce_default", "kind", "successful_without_retry"}).functionCounter().count());
            Assertions.assertEquals((double)0.0, (double)bootstrap.meterRegistry().get("resilience4j.retry.calls").tags(new String[]{"name", "ServiceApi_failOnce_default", "kind", "failed_without_retry"}).functionCounter().count());
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testNoRetryCauseCustomConfig() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg.factory()), new Class[]{AppConfig.class});
        ConfigurableApplicationContext applicationContext = bootstrap.run(new String[0]);
        try {
            ServiceApi serviceApi = (ServiceApi)applicationContext.getBean(ServiceApi.class);
            Assertions.assertThrows(RuntimeException.class, serviceApi::failInstantly);
            Assertions.assertEquals((int)1, (int)ServiceApi.ATTEMPTED_COUNT.getAndSet(0));
            Assertions.assertEquals((double)0.0, (double)bootstrap.meterRegistry().get("resilience4j.retry.calls").tags(new String[]{"name", "ServiceApi_failInstantly_custom", "kind", "successful_with_retry"}).functionCounter().count());
            Assertions.assertEquals((double)0.0, (double)bootstrap.meterRegistry().get("resilience4j.retry.calls").tags(new String[]{"name", "ServiceApi_failInstantly_custom", "kind", "failed_with_retry"}).functionCounter().count());
            Assertions.assertEquals((double)0.0, (double)bootstrap.meterRegistry().get("resilience4j.retry.calls").tags(new String[]{"name", "ServiceApi_failInstantly_custom", "kind", "successful_without_retry"}).functionCounter().count());
            Assertions.assertEquals((double)1.0, (double)bootstrap.meterRegistry().get("resilience4j.retry.calls").tags(new String[]{"name", "ServiceApi_failInstantly_custom", "kind", "failed_without_retry"}).functionCounter().count());
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testUnknown() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg.factory()), new Class[]{AppConfig.class});
        ConfigurableApplicationContext applicationContext = bootstrap.run(new String[0]);
        try {
            ServiceApi serviceApi = (ServiceApi)applicationContext.getBean(ServiceApi.class);
            Assertions.assertThrows(RuntimeException.class, serviceApi::doNotRetry);
            Assertions.assertEquals((int)1, (int)ServiceApi.ATTEMPTED_COUNT.getAndSet(0));
            Assertions.assertTrue((boolean)bootstrap.meterRegistry().find("resilience4j.retry.calls").functionCounters().isEmpty());
        }
        finally {
            bootstrap.shutdown();
        }
    }

    @Configuration
    @EnableAspectJAutoProxy(proxyTargetClass=true)
    public static class AppConfig {
        @Bean(value={"custom"})
        public RetryConfig customConfig() {
            return RetryConfig.custom().maxAttempts(3).retryExceptions(new Class[]{SocketTimeoutException.class}).build();
        }

        @Bean
        public RetryAspect aspect(RetryRegistry retryRegistry) {
            return new RetryAspect(retryRegistry);
        }

        @Bean
        public ServiceApi serviceApi() {
            return new ServiceApi();
        }
    }

    public static class ServiceApi {
        public static AtomicInteger ATTEMPTED_COUNT = new AtomicInteger(0);

        @Retryable
        public void failOnce() {
            if (ATTEMPTED_COUNT.getAndIncrement() == 0) {
                throw new RuntimeException("Temporary error");
            }
        }

        @Retryable(config="custom")
        public void failInstantly() {
            if (ATTEMPTED_COUNT.getAndIncrement() == 0) {
                throw new RuntimeException("Temporary error");
            }
        }

        @Retryable(config="unknown")
        public void doNotRetry() {
            if (ATTEMPTED_COUNT.getAndIncrement() == 0) {
                throw new RuntimeException("Temporary error");
            }
        }
    }
}

