package com.turbospaces.executor;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

import reactor.blockhound.integration.DefaultBlockHoundIntegration;

public class BlockhoundThreadPoolExecutorWrapper extends ScheduledThreadPoolExecutor {
    private final ThreadLocal<Boolean> flag = DefaultBlockHoundIntegration.FLAG;

    public BlockhoundThreadPoolExecutorWrapper(
            int corePoolSize,
            ThreadFactory threadFactory,
            RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }
    @Override
    public boolean prestartCoreThread() {
        boolean toReset = flag.get();
        try {
            flag.set(false);
            return super.prestartCoreThread();
        } finally {
            flag.set(toReset);
        }
    }
}
