package com.turbospaces.cfg;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import com.configcat.ConfigCatClient;
import com.netflix.archaius.config.PollingDynamicConfig;
import com.netflix.archaius.config.polling.FixedPollingStrategy;
import com.netflix.archaius.config.polling.PollingResponse;

public class ConfigCatConfig extends PollingDynamicConfig {

    public ConfigCatConfig(ConfigCatClient config, Duration refreshInterval) {
        super(() -> pull(config), new FixedPollingStrategy(refreshInterval.toSeconds(), TimeUnit.SECONDS));
    }

    private static PollingResponse pull(ConfigCatClient config) {
        config.forceRefresh();

        var values = config.getAllValues(null).entrySet().stream()
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        entry -> String.valueOf(entry.getValue())));

        return PollingResponse.forSnapshot(values);
    }
}
