/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.netflix.archaius.api.annotations.Configuration;
import com.turbospaces.boot.MockBootstrap;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.support.TimedConfiguration;
import io.micrometer.core.annotation.Timed;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@Import(value={TimedConfiguration.class})
public class MockConfig {
    private static final Logger log = LoggerFactory.getLogger(MockConfig.class);

    @Bean
    public HttpFactory factory(HttpClientBuilder client) {
        return new HttpFactory(client);
    }

    @Bean
    public Foo foo(HttpFactory factory) throws Exception {
        return new Foo((CloseableHttpClient)factory.getObject());
    }

    @Scheduled(fixedRate=1000L)
    public void mock() {
        log.info("The time is now {}", (Object)new SimpleDateFormat("HH:mm:ss").format(new Date()));
    }

    @Bean
    public MockBootstrap.InboundChannel inboundChannel(ApplicationProperties props) throws Exception {
        URIBuilder uri = new URIBuilder().setScheme("http").setHost("localhost").setPath("/v1/status").setPort(((Integer)props.CLOUD_APP_PORT.get()).intValue());
        return new MockBootstrap.InboundChannel(props, uri.build());
    }

    public static class HttpFactory
    extends AbstractFactoryBean<CloseableHttpClient> {
        private final HttpClientBuilder builder;

        public HttpFactory(HttpClientBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
        }

        public Class<?> getObjectType() {
            return CloseableHttpClient.class;
        }

        protected CloseableHttpClient createInstance() throws Exception {
            return this.builder.build();
        }

        protected void destroyInstance(CloseableHttpClient instance) throws Exception {
            instance.close();
        }
    }

    public static class Foo
    implements InitializingBean,
    DisposableBean {
        @Value(value="cloud.application.app-id")
        String appId;
        private final CloseableHttpClient client;

        @Inject
        public Foo(CloseableHttpClient client) {
            this.client = Objects.requireNonNull(client);
        }

        public void afterPropertiesSet() throws Exception {
            log.debug("Starting foo bean now ...");
        }

        public void destroy() throws Exception {
            log.debug("Stopping foo bean now ...");
        }

        @Timed
        public void print() throws InterruptedException {
            final CountDownLatch l = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    log.debug(this.toString());
                    l.countDown();
                }
            }).start();
            Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        }

        public String toString() {
            ToStringBuilder toString = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
            return toString.append("appId", (Object)this.appId).append("client", (Object)this.client).build();
        }
    }
}

