/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.rpc;

import api.v1.ApiFactory;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.turbospaces.api.facade.HeadersFacade;
import com.turbospaces.api.facade.RequestWrapperFacade;
import com.turbospaces.api.facade.ResponseStatusFacade;
import com.turbospaces.api.facade.ResponseWrapperFacade;
import com.turbospaces.api.mappers.ResponseFacadeMapper;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.dispatch.AbstractSafeResponseConsumer;
import com.turbospaces.rpc.ApiResponse;
import com.turbospaces.rpc.CompletableRequestReplyMapper;
import com.turbospaces.rpc.DefaultApiResponse;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeResponseConsumerTest {
    private static final Logger log = LoggerFactory.getLogger(SafeResponseConsumerTest.class);

    SafeResponseConsumerTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void works() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            final SettableFuture future = SettableFuture.create();
            final Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            ResponseWrapperFacade respw = (ResponseWrapperFacade)Mockito.mock(ResponseWrapperFacade.class);
            RequestWrapperFacade reqw = (RequestWrapperFacade)Mockito.mock(RequestWrapperFacade.class);
            Mockito.when((Object)reqw.body()).thenReturn((Object)Any.pack((Message)req));
            Mockito.when((Object)reqw.toReply((Message)ArgumentMatchers.any(), (ResponseStatusFacade)ArgumentMatchers.any())).thenReturn((Object)respw);
            boot.globalPlatform().execute(new Runnable(){

                @Override
                public void run() {
                    future.set((Object)new ResponseWrapperFacade(){

                        public byte[] toBytes() {
                            return this.body().toByteArray();
                        }

                        public ResponseStatusFacade status() {
                            return (ResponseStatusFacade)Mockito.mock(ResponseStatusFacade.class);
                        }

                        public HeadersFacade headers() {
                            return (HeadersFacade)Mockito.mock(HeadersFacade.class);
                        }

                        public Any body() {
                            return Any.pack((Message)req);
                        }
                    });
                }
            });
            DefaultApiResponse apiResponse = new DefaultApiResponse((ListenableFuture)future, Timestamp.class, reqw);
            final CountDownLatch latch = new CountDownLatch(1);
            AbstractSafeResponseConsumer consumer = new AbstractSafeResponseConsumer((ApiResponse)apiResponse, (ApiFactory)Mockito.mock(ApiFactory.class)){

                public void accept(ResponseWrapperFacade t) throws Throwable {
                    latch.countDown();
                }
            };
            consumer.run();
            latch.await();
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void exception() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            final SettableFuture future = SettableFuture.create();
            final Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            ResponseWrapperFacade respw = (ResponseWrapperFacade)Mockito.mock(ResponseWrapperFacade.class);
            RequestWrapperFacade reqw = (RequestWrapperFacade)Mockito.mock(RequestWrapperFacade.class);
            Mockito.when((Object)reqw.body()).thenReturn((Object)Any.pack((Message)req));
            Mockito.when((Object)reqw.toReply((Message)ArgumentMatchers.any(), (ResponseStatusFacade)ArgumentMatchers.any())).thenReturn((Object)respw);
            boot.globalPlatform().execute(new Runnable(){

                @Override
                public void run() {
                    future.set((Object)new ResponseWrapperFacade(){

                        public byte[] toBytes() {
                            return this.body().toByteArray();
                        }

                        public ResponseStatusFacade status() {
                            return (ResponseStatusFacade)Mockito.mock(ResponseStatusFacade.class);
                        }

                        public HeadersFacade headers() {
                            return (HeadersFacade)Mockito.mock(HeadersFacade.class);
                        }

                        public Any body() {
                            return Any.pack((Message)req);
                        }
                    });
                }
            });
            DefaultApiResponse apiResponse = new DefaultApiResponse((ListenableFuture)future, Timestamp.class, reqw);
            final CountDownLatch latch = new CountDownLatch(1);
            AbstractSafeResponseConsumer consumer = new AbstractSafeResponseConsumer((ApiResponse)apiResponse, (ApiFactory)Mockito.mock(ApiFactory.class)){

                public void onFailure(Throwable t) {
                    super.onFailure(t);
                    latch.countDown();
                }

                public void accept(ResponseWrapperFacade t) throws Throwable {
                    throw new IllegalArgumentException();
                }
            };
            consumer.run();
            latch.await();
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void timeout() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            SettableFuture future = SettableFuture.create();
            FluentFuture fluent = FluentFuture.from((ListenableFuture)future).withTimeout(Duration.ofMillis(1L), (ScheduledExecutorService)boot.globalPlatform());
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            ResponseStatusFacade statusw = (ResponseStatusFacade)Mockito.mock(ResponseStatusFacade.class);
            Mockito.when((Object)statusw.isTimeout()).thenReturn((Object)true);
            ResponseWrapperFacade respw = (ResponseWrapperFacade)Mockito.mock(ResponseWrapperFacade.class);
            Mockito.when((Object)respw.status()).thenReturn((Object)statusw);
            ResponseFacadeMapper respMapper = (ResponseFacadeMapper)Mockito.mock(ResponseFacadeMapper.class);
            Mockito.when((Object)respMapper.toTimeoutReplyWithoutBody((Throwable)ArgumentMatchers.any())).thenReturn((Object)respw);
            ApiFactory apiFactory = (ApiFactory)Mockito.mock(ApiFactory.class);
            Mockito.when((Object)apiFactory.responseMapper()).thenReturn((Object)respMapper);
            RequestWrapperFacade reqw = (RequestWrapperFacade)Mockito.mock(RequestWrapperFacade.class);
            Mockito.when((Object)reqw.body()).thenReturn((Object)Any.pack((Message)req));
            DefaultApiResponse apiResponse = new DefaultApiResponse((ListenableFuture)fluent, Timestamp.class, reqw);
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference code = new AtomicReference();
            AbstractSafeResponseConsumer consumer = new AbstractSafeResponseConsumer((ApiResponse)apiResponse, apiFactory){

                public void accept(ResponseWrapperFacade t) throws Throwable {
                    code.set(t.status().isTimeout());
                    log.debug(t.status().errorText());
                    latch.countDown();
                }
            };
            consumer.run();
            latch.await();
            Assertions.assertTrue((boolean)((Boolean)code.get()));
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void timeoutWithMapper() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            CompletableRequestReplyMapper mapper = new CompletableRequestReplyMapper();
            mapper.initialize();
            SettableFuture future = mapper.acquire((Object)UUID.randomUUID().toString(), Duration.ofMillis(1L));
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            ResponseStatusFacade statusw = (ResponseStatusFacade)Mockito.mock(ResponseStatusFacade.class);
            Mockito.when((Object)statusw.isTimeout()).thenReturn((Object)true);
            ResponseWrapperFacade respw = (ResponseWrapperFacade)Mockito.mock(ResponseWrapperFacade.class);
            Mockito.when((Object)respw.status()).thenReturn((Object)statusw);
            ResponseFacadeMapper respMapper = (ResponseFacadeMapper)Mockito.mock(ResponseFacadeMapper.class);
            Mockito.when((Object)respMapper.toTimeoutReplyWithoutBody((Throwable)ArgumentMatchers.any())).thenReturn((Object)respw);
            ApiFactory apiFactory = (ApiFactory)Mockito.mock(ApiFactory.class);
            Mockito.when((Object)apiFactory.responseMapper()).thenReturn((Object)respMapper);
            RequestWrapperFacade reqw = (RequestWrapperFacade)Mockito.mock(RequestWrapperFacade.class);
            Mockito.when((Object)reqw.body()).thenReturn((Object)Any.pack((Message)req));
            DefaultApiResponse apiResponse = new DefaultApiResponse((ListenableFuture)future, Timestamp.class, reqw);
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference code = new AtomicReference();
            AbstractSafeResponseConsumer consumer = new AbstractSafeResponseConsumer((ApiResponse)apiResponse, apiFactory){

                public void accept(ResponseWrapperFacade t) throws Throwable {
                    code.set(t.status().isTimeout());
                    log.debug(t.status().errorText());
                    latch.countDown();
                }
            };
            consumer.run();
            latch.await();
            mapper.destroy();
            Assertions.assertTrue((boolean)((Boolean)code.get()));
        }
        finally {
            boot.shutdown();
        }
    }
}

