/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ups.ServiceInfoSubscription;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.cloud.service.BaseServiceInfo;
import org.springframework.cloud.service.ServiceInfo;
import uk.org.webcompere.systemstubs.jupiter.SystemStubsExtension;

@ExtendWith(value={SystemStubsExtension.class})
public class ServiceInfoSubscriptionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void subscribeForScopeAndName_addNameBeforeScope() throws Throwable {
        final String scope = Long.toString(System.currentTimeMillis());
        final String ups = UUID.randomUUID().toString();
        final UUID uuid = UUID.randomUUID();
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        try {
            final AtomicInteger invocationCounter = new AtomicInteger(0);
            ServiceInfoSubscription serviceInfoSubscription = ServiceInfoSubscription.of((Bootstrap)bootstrap, (String)scope, (String)ups, (Consumer)new Consumer<ServiceInfo>(){

                @Override
                public void accept(ServiceInfo serviceInfo) {
                    invocationCounter.incrementAndGet();
                }
            });
            final CountDownLatch executedAddName = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(ups));
                    executedAddName.countDown();
                }
            }).start();
            Assertions.assertTrue((boolean)executedAddName.await(20L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)1, (int)invocationCounter.get());
            Assertions.assertEquals((Object)ups, (Object)serviceInfoSubscription.get().getId());
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(ups));
            final CountDownLatch executedAddScope = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(uuid + "-" + ups));
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(scope + "-" + ups));
                    executedAddScope.countDown();
                }
            }).start();
            Assertions.assertTrue((boolean)executedAddScope.await(20L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)2, (int)invocationCounter.get());
            Assertions.assertEquals((Object)(scope + "-" + ups), (Object)serviceInfoSubscription.get().getId());
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(scope + "-" + ups));
            final CountDownLatch executedRemove = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.removeUps(ups);
                    bootstrap.removeUps(scope + "-" + ups);
                    bootstrap.removeUps(uuid + "-" + ups);
                    executedRemove.countDown();
                }
            }).start();
            Assertions.assertTrue((boolean)executedRemove.await(20L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)2, (int)invocationCounter.get());
            Assertions.assertTrue((boolean)bootstrap.cloud().getServiceInfos().isEmpty());
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void subscribeForScopeAndName_addScopeBeforeName() throws Throwable {
        final String scope = Long.toString(System.currentTimeMillis());
        final String ups = UUID.randomUUID().toString();
        final UUID uuid = UUID.randomUUID();
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        try {
            final AtomicInteger invocationCounter = new AtomicInteger(0);
            ServiceInfoSubscription serviceInfoSubscription = ServiceInfoSubscription.of((Bootstrap)bootstrap, (String)scope, (String)ups, (Consumer)new Consumer<ServiceInfo>(){

                @Override
                public void accept(ServiceInfo serviceInfo) {
                    invocationCounter.incrementAndGet();
                }
            });
            final CountDownLatch executedAddScope = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(uuid + "-" + ups));
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(scope + "-" + ups));
                    executedAddScope.countDown();
                }
            }).start();
            Assertions.assertTrue((boolean)executedAddScope.await(20L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)1, (int)invocationCounter.get());
            Assertions.assertEquals((Object)(scope + "-" + ups), (Object)serviceInfoSubscription.get().getId());
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(scope + "-" + ups));
            final CountDownLatch executedAddName = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(ups));
                    executedAddName.countDown();
                }
            }).start();
            Assertions.assertTrue((boolean)executedAddName.await(20L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)1, (int)invocationCounter.get());
            Assertions.assertNotEquals((Object)ups, (Object)serviceInfoSubscription.get().getId());
            Assertions.assertEquals((Object)(scope + "-" + ups), (Object)serviceInfoSubscription.get().getId());
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(ups));
            final CountDownLatch executedRemove = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.removeUps(ups);
                    bootstrap.removeUps(scope + "-" + ups);
                    bootstrap.removeUps(uuid + "-" + ups);
                    executedRemove.countDown();
                }
            }).start();
            Assertions.assertTrue((boolean)executedRemove.await(20L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)1, (int)invocationCounter.get());
            Assertions.assertTrue((boolean)bootstrap.cloud().getServiceInfos().isEmpty());
        }
        finally {
            bootstrap.shutdown();
        }
    }
}

