package com.turbospaces.cfg;

import java.lang.reflect.Type;
import java.util.function.Function;

import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.Property;

public class DynamicPropertyFactory extends DefaultPropertyFactory {
    private DynamicPropertyFactory(Config config) {
        super(config);
    }
    @Override
    public ApplicationConfig getConfig() {
        return (ApplicationConfig) super.getConfig();
    }
    public static DynamicPropertyFactory from(Config config) {
        return new DynamicPropertyFactory(config);
    }
    @Override
    public <T> Property<T> get(String key, Class<T> type) {
        return super.get(key, type);
    }
    @Override
    public <T> Property<T> get(String key, Type type) {
        return super.get(key, type);
    }
    public <T> ScopedProperty<T> getScoped(String key, Class<T> type, T defaultValue) {
        return new ScopedProperty<T>(
                key,
                new Function<String, Property<T>>() {
                    @Override
                    public Property<T> apply(String t) {
                        return get(t, type).orElse(defaultValue);
                    }
                });
    }
}
