/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.netflix.archaius.api.Property;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.DynamicPropertyFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DynamicPropertyFactoryTest {
    private static final String PROPERTY_NAME = "soft-kyc-required-before-purchase.percentage.users-applied";
    private static final int DEFAULT_VALUE = 1;
    private static final String WRONG_VALUE = "50akDFs83$#%#";
    private static final int CORRECT_VALUE = 50;

    @Test
    public void testOrElseGetCorrectValue() {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, 50);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)50, (Integer)integerValue);
    }

    @Test
    public void testOrElseGetWrongValueDefault() {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, WRONG_VALUE);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)1, (Integer)integerValue);
    }

    @Test
    public void testOrElseGetNullValueDefault() {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, null);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)1, (Integer)integerValue);
    }

    @Test
    public void testOrElseGetEmptyValueDefault() {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, "");
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)1, (Integer)integerValue);
    }

    @Test
    public void testGetCorrectValue() {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, 50);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)50, (Integer)integerValue);
    }

    @Test
    public void testWrongValueDefault() {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, WRONG_VALUE);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)1, (Integer)integerValue);
    }

    @Test
    public void testGetNullValueNull() {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, null);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.get();
        Assertions.assertNull((Object)integerValue);
    }

    @Test
    public void testGetEmptyValueNull() {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, "");
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.get();
        Assertions.assertNull((Object)integerValue);
    }

    private static DynamicPropertyFactory createDynamicPropertyFactory(String name, String value) {
        ApplicationConfig cfg = ApplicationConfig.mock();
        cfg.setLocalProperty(name, (Object)value);
        return cfg.factory();
    }

    private static DynamicPropertyFactory createDynamicPropertyFactory(String name, int value) {
        ApplicationConfig cfg = ApplicationConfig.mock();
        cfg.setLocalProperty(name, (Object)String.valueOf(value));
        return cfg.factory();
    }
}

