/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.MockConfig;
import com.turbospaces.boot.MockSpringBootTestContextBootstrapper;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.healthchecks.HttpHealthCheck;
import com.turbospaces.healthchecks.SocketHealthCheck;
import com.turbospaces.ups.PlainServiceInfo;
import io.jaegertracing.client.Version;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;
import org.apache.http.client.utils.URIBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.service.UriBasedServiceInfo;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@BootstrapWith(value=MockSpringBootTestContextBootstrapper.class)
@ContextConfiguration(classes={MockConfig.class})
public class BootstrapTest {
    private static final Logger log = LoggerFactory.getLogger(BootstrapTest.class);
    @Autowired
    private MockConfig.Foo foo;
    @Autowired
    private ApplicationProperties props;

    @Test
    public void works() throws Throwable {
        URIBuilder uri = new URIBuilder().setScheme("http").setHost("localhost").setPath("/v1/status").setPort(((Integer)this.props.CLOUD_APP_PORT.get()).intValue());
        HttpHealthCheck check1 = new HttpHealthCheck(this.props, uri.build());
        Assertions.assertTrue((boolean)check1.execute().isHealthy());
        RestorableUniformRandomProvider rng = RandomSource.XO_RO_SHI_RO_128_PP.create();
        SocketHealthCheck check2 = new SocketHealthCheck(this.props, (UriBasedServiceInfo)new PlainServiceInfo(rng.nextBoolean() + "-" + Version.get(), uri.toString()));
        Assertions.assertTrue((boolean)check2.execute().isHealthy());
        log.debug(this.foo.toString());
    }
}

