/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.turbospaces.api.facade.ResponseWrapperFacade;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.rpc.CompletableRequestReplyMapper;
import com.turbospaces.rpc.DefaultRequestReplyMapper;
import com.turbospaces.rpc.RequestReplyTimeout;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.search.RequiredSearch;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CompletableRequestReplyMapperTest {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    CompletableRequestReplyMapper<UUID, ResponseWrapperFacade> mapper;

    @AfterEach
    public void after() throws Exception {
        this.mapper.destroy();
    }

    @Test
    public void works() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        ApplicationProperties props = new ApplicationProperties(cfg.factory());
        SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
        this.mapper = new DefaultRequestReplyMapper(props, (MeterRegistry)meterRegistry);
        this.mapper.afterPropertiesSet();
        UUID key = PlatformUtil.randomUUID();
        final CountDownLatch l = new CountDownLatch(1);
        SettableFuture f = this.mapper.acquire((Object)key, Duration.ofSeconds(15L));
        f.addListener(new Runnable(){

            @Override
            public void run() {
                l.countDown();
            }
        }, MoreExecutors.directExecutor());
        Assertions.assertEquals((int)1, (int)this.mapper.pendingCount());
        MDC.put((String)"operation", (String)"test");
        this.mapper.complete((Object)key, (Object)((ResponseWrapperFacade)Mockito.mock(ResponseWrapperFacade.class)));
        Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)0, (int)this.mapper.pendingCount());
        RequiredSearch search1 = meterRegistry.get("reply.complete.latency").tag("operation", "test");
        Assertions.assertNotNull((Object)search1.timer());
    }

    @Test
    public void timeoutRaw() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        ApplicationProperties props = new ApplicationProperties(cfg.factory());
        SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
        this.mapper = new CompletableRequestReplyMapper(props, (MeterRegistry)meterRegistry);
        this.mapper.afterPropertiesSet();
        UUID key = PlatformUtil.randomUUID();
        CountDownLatch l = new CountDownLatch(1);
        SettableFuture f = this.mapper.acquire((Object)key, Duration.ofMillis(1L));
        f.addListener(new Runnable(){
            final /* synthetic */ ListenableFuture val$f;
            final /* synthetic */ CountDownLatch val$l;
            {
                this.val$f = listenableFuture;
                this.val$l = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    this.val$f.get();
                }
                catch (Exception err) {
                    RequestReplyTimeout timeout = (RequestReplyTimeout)err.getCause();
                    CompletableRequestReplyMapperTest.this.logger.error(timeout.getMessage(), (Throwable)timeout);
                    this.val$l.countDown();
                }
            }
        }, MoreExecutors.directExecutor());
        Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CompletableRequestReplyMapperTest.this.mapper.pendingCount() == 0;
            }
        });
    }

    @Test
    public void timeoutFluent() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        ApplicationProperties props = new ApplicationProperties(cfg.factory());
        SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
        this.mapper = new DefaultRequestReplyMapper(props, (MeterRegistry)meterRegistry);
        this.mapper.afterPropertiesSet();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        UUID key = PlatformUtil.randomUUID();
        final CountDownLatch l = new CountDownLatch(1);
        FluentFuture f = FluentFuture.from((ListenableFuture)this.mapper.acquire((Object)key, Duration.ofMillis(1L)));
        f.addCallback((FutureCallback)new FutureCallback<ResponseWrapperFacade>(){

            public void onSuccess(ResponseWrapperFacade result) {
            }

            public void onFailure(Throwable t) {
                RequestReplyTimeout timeout = (RequestReplyTimeout)ExceptionUtils.getRootCause((Throwable)t);
                CompletableRequestReplyMapperTest.this.logger.error(timeout.getMessage(), (Throwable)timeout);
                l.countDown();
            }
        }, (Executor)executor);
        Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CompletableRequestReplyMapperTest.this.mapper.pendingCount() == 0;
            }
        });
        executor.shutdown();
    }

    @Test
    public void exceptionally() throws Throwable {
        ApplicationConfig cfg = ApplicationConfig.mock();
        ApplicationProperties props = new ApplicationProperties(cfg.factory());
        SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
        this.mapper = new DefaultRequestReplyMapper(props, (MeterRegistry)meterRegistry);
        this.mapper.afterPropertiesSet();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        UUID key = PlatformUtil.randomUUID();
        final CountDownLatch l = new CountDownLatch(1);
        FluentFuture f = FluentFuture.from((ListenableFuture)this.mapper.acquire((Object)key, Duration.ofMinutes(1L)));
        f.addCallback((FutureCallback)new FutureCallback<ResponseWrapperFacade>(){

            public void onSuccess(ResponseWrapperFacade result) {
            }

            public void onFailure(Throwable t) {
                l.countDown();
            }
        }, (Executor)executor);
        this.mapper.completeExceptionally((Object)key, (Throwable)new IllegalStateException());
        Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CompletableRequestReplyMapperTest.this.mapper.pendingCount() == 0;
            }
        });
        executor.shutdown();
    }
}

