package com.turbospaces.support;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

import com.turbospaces.aspects.NonBlockingCallOnlyAspect;
import com.turbospaces.cfg.ApplicationProperties;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass = true)
public class NonBlockingCallConfiguration {
    @Bean
    public NonBlockingCallOnlyAspect nonBlockingCallOnlyAspect(ApplicationProperties props) {
        return new NonBlockingCallOnlyAspect(props);
    }
}
